<?php echo $__env->make('layouts.header', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
   <main>
    <div class="mb-4 pb-4"></div>
    <section class="shop-checkout container mb-5">
      <h2 class="page-title">Cart</h2>
      <!-- <div class="checkout-steps">
        <a href="cart.php" class="checkout-steps__item active">
          <span class="checkout-steps__item-number">01</span>
          <span class="checkout-steps__item-title">
            <span>Shopping Bag</span>
            <em>Manage Your Items List</em>
          </span>
        </a>
        <a href="shop-checkout.php" class="checkout-steps__item">
          <span class="checkout-steps__item-number">02</span>
          <span class="checkout-steps__item-title">
            <span>Shipping and Checkout</span>
            <em>Checkout Your Items List</em>
          </span>
        </a>
        <a href="shop-order-complete.php" class="checkout-steps__item">
          <span class="checkout-steps__item-number">03</span>
          <span class="checkout-steps__item-title">
            <span>Confirmation</span>
            <em>Review And Submit Your Order</em>
          </span>
        </a>
      </div> -->
      <?php if($cart->isEmpty()): ?>
          <h2 style="
            text-align: center;
            margin-top: 20%;
            margin-bottom: 20%;
            color: red;
        ">Your Cart Is Empty...</h2>
      <?php else: ?>
      <div class="shopping-cart">
        <div class="cart-table__wrapper">
          <table class="cart-table">
            <thead>
              <tr>
                <th>Product</th>
                <th></th>
                <th>Price</th>
                <th>Quantity</th>
                <th>Subtotal</th>
                <th></th>
              </tr>
            </thead>
            <tbody>
          
            <?php $__currentLoopData = $cart; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>              
              <tr>
                <td>
                  <div class="shopping-cart__product-item">
                    <a href="<?php echo e(route('products', ['category' => $item->product->category->slug, 'product_id' => $item->product->product_id, 'sub_sku' => $item->product->sub_sku, 'slug' => $item->product->slug ?? '', 'size' => $item->product->size ?? '', 'color' => $item->product->color ?? ''])); ?>">
                      <img loading="lazy" src="<?php echo e(asset('uploads/products/' . $item->product->featured_image ?? '')); ?>" width="120" height="120" alt="">
                    </a>
                  </div>
                </td>
                <td>
                  <div class="shopping-cart__product-item__detail">
                    <h4><a href="<?php echo e(route('products', ['category' => $item->product->category->slug, 'product_id' => $item->product->product_id, 'sub_sku' => $item->product->sub_sku, 'slug' => $item->product->slug ?? '', 'size' => $item->product->size ?? '', 'color' => $item->product->color ?? ''])); ?>">
                      <?php echo e($item->product->name ?? ''); ?></a></h4>
                    <ul class="shopping-cart__product-item__options">
                      <li>Color: <?php echo e(ucwords($item->product->color ?? '')); ?></li>
                      <li>Size: <?php echo e($item->product->size ?? ''); ?></li> 
                                           
                      <?php if($item->quantity >= $item->stock): ?>
                      <li><span style="color:red;">Sorry, stock is not available right now. You can't add more!</span></li>
                      <?php endif; ?>
                    </ul>
                  </div>
                </td>
                <td>
                  <?php if(isset($item->product->selling_price) && $item->product->selling_price != 0): ?>
                      <span class="money price price-old">Rs. <?php echo e($item->product->mrp ?? ''); ?></span>
                      <span class="money price pr-color">Rs. <?php echo e($item->price ?? ''); ?></span>
                      <?php else: ?>
                      <span class="shopping-cart__product-price">Rs. <?php echo e($item->price ?? ''); ?></span>
                      <?php endif; ?>
                  <!-- <span class="shopping-cart__product-price">Rs. <?php echo e($item->price ?? ''); ?></span> -->
                </td>
                <td>
                <div class="stock-message text-danger" style="display: none;"></div>
                  <form action="<?php echo e(route('cart.update', $item->id)); ?>" method="POST" class="qty-control-form">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('PUT'); ?>
                    <div class="qty-control position-relative">
                     
                      <input type="number" name="quantity" value="<?php echo e($item->quantity ?? 1); ?>" min="1" max="<?php echo e($item->stock ?? 1); ?>" class="qty-control__number text-center">
                      <button style="border: none;" type="button" class="qty-control__reduce">-</button>            
                      <!-- <button style="border: none;" type="button" class="qty-control__increase">+</button> -->
                      <button style="border: none;" type="button" class="qty-control__increase <?php echo e($item->quantity >= $item->stock ? 'disabled' : ''); ?>" <?php echo e($item->quantity >= $item->stock ? 'disabled' : ''); ?>>+</button>
                      
                    </div>
                    </form>
                </td>
                <td>
                  <span class="shopping-cart__subtotal">Rs. <?php echo e($item->sub_total ?? ''); ?></span>
                  <!-- <?php
                      $totalmrp = $item->product->mrp * $item->quantity;
                      $totalsellingprice = $item->product->selling_price * $item->quantity;
                      $Ofprice = $totalmrp - $totalsellingprice;
                  ?>

                  <?php if(isset($item->product->selling_price) && $item->product->selling_price != 0): ?>
                      <span class="money price price-old">Rs. <?php echo e($Ofprice ?? ''); ?></span>
                  <?php endif; ?> -->
                </td>
                <td>
                  <a href="<?php echo e(route('delete.cart', $item->id)); ?>">
                    <svg width="10" height="10" viewBox="0 0 10 10" fill="#767676" xmlns="http://www.w3.org/2000/svg">
                      <path d="M0.259435 8.85506L9.11449 0L10 0.885506L1.14494 9.74056L0.259435 8.85506Z"/>
                      <path d="M0.885506 0.0889838L9.74057 8.94404L8.85506 9.82955L0 0.97449L0.885506 0.0889838Z"/>
                    </svg>                  
                  </a>
                </td>
              </tr> 
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> 
                  
            </tbody>
          </table>
          <?php if($msg != ''): ?>
          <div class="alert alert-danger alert-dismissible">           
            <strong>Error!</strong> <?php echo e($msg); ?>

            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
          </div>          
          <?php endif; ?>
          <div class="cart-table-footer"> 
          
            <form action="<?php echo e(route('cart')); ?>" class="position-relative bg-body" method="get">
              <input class="form-control" type="text" name="coupon_code" placeholder="Coupon Code">
              <input class="btn-link fw-medium position-absolute top-0 end-0 h-100 px-4" type="submit" value="APPLY COUPON">
            </form>
            <!-- <button class="btn btn-light">UPDATE CART</button> -->
          </div>
        </div>
        <div class="shopping-cart__totals-wrapper">
          <div class="sticky-content">
            <div class="shopping-cart__totals">
              <h3>Cart Totals</h3>
              <table class="cart-totals">
                <tbody>
                  <tr>
                    <th>MRP</th>
                      <td>Rs. <?php echo e($subtotalmrp ?? ''); ?></td>
                  </tr>
                  <tr>
                    <th>Discount On MRP</th>                  
                    <td><span class="money price pr-color">Rs. <?php echo e($subtotalmrp - $sub_total ?? ''); ?></span></td>
                  </tr>
                  
                  <?php if($coupon_code_price != 0 ): ?>
                  <tr>
                    <th>Coupon Discount</th>
                    <td>Rs. <?php echo e($coupon_code_price ?? ''); ?> (<?php echo e($coupon); ?>)</td>
                  </tr>
                  <?php endif; ?>
                  <!-- <tr>
                    <th>Total Discount</th>
                    <td><span class="money price pr-color">Rs. <?php echo e($total_discount ?? ''); ?></span></td>
                  </tr> -->
                  <tr>
                    <th>Total</th>
                    <td>Rs. <?php echo e(($subtotalmrp - $total_discount) ?? ''); ?></td>
                  </tr>
                </tbody>
              </table>
            </div>
            <div class="mobile_fixed-btn_wrapper">
              <?php
                  $coupon_discount = $coupon_code_price ?? 0; // fallback to 0 if not set
                  $total = $subtotalmrp - $total_discount;
                  // Store in session
                  session([
                      'checkout_subtotalmrp' => $subtotalmrp,
                      'checkout_total' => $total,
                      'checkout_coupon_discount' => $coupon_discount,
                      'checkout_sub_total' => $sub_total,
                      'checkout_coupon' => $coupon
                  ]);
              ?>
              <div class="button-wrapper container">
                  <a href="<?php echo e(route('shop.checkout')); ?>" class="btn btn-primary btn-checkout">PROCEED TO CHECKOUT</a>
                  <!-- <a href="<?php echo e(route('shop.checkout', ['user_id'=>$cart[0]->user_id] )); ?>" class="btn btn-primary btn-checkout">PROCEED TO CHECKOUT</a> -->
                <!--<button class="btn btn-primary btn-checkout">PROCEED TO CHECKOUT</button>-->
              </div>
            </div>
          </div>
        </div>
      </div>
       <?php endif; ?>  
    </section>
  </main>

<?php echo $__env->make('layouts.footer', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<script>
document.addEventListener('DOMContentLoaded', function () {
    document.querySelectorAll('.qty-control').forEach(function (control) {
        const input = control.querySelector('.qty-control__number');
        const increase = control.querySelector('.qty-control__increase');
        const reduce = control.querySelector('.qty-control__reduce');
        // let max = <?php echo e($item->stock ?? 1); ?>;
        let max = parseInt(input.getAttribute('max'));

        increase.addEventListener('click', function () {
          if (parseInt(input.value) < max) {
            input.value = parseInt(input.value) + 1;
            input.form.submit(); // auto-submit form if needed
          }  
        });

        reduce.addEventListener('click', function () {
            if (parseInt(input.value) > 1) {
                input.value = parseInt(input.value) - 1;
                input.form.submit(); // auto-submit form if needed
            }
        });
    });
});
</script>



<?php /**PATH /home/hubto/public_html/griffin/resources/views/cart.blade.php ENDPATH**/ ?>