<?php echo $__env->make('admin.layouts.header', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<?php echo $__env->make('admin.layouts.sidebar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?> 

<link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css">                 
        <!-- Vertical Overlay-->
        <div class="vertical-overlay"></div>
        <div class="main-content">

            <div class="page-content">
                <div class="container-fluid">
                    <div class="row">
                        <div class="col-12">
                            <div class="page-title-box d-sm-flex align-items-center justify-content-between bg-galaxy-transparent">
                                <h4 class="mb-sm-0">Brand List</h4>

                                <div class="page-title-right">
                                    <ol class="breadcrumb m-0">
                                        <li class="breadcrumb-item"><a href="javascript: void(0);">Tables</a></li>
                                        <li class="breadcrumb-item active">Brand List</li>
                                    </ol>
                                </div>

                            </div>
                        </div>
                    </div>
                    <!-- end page title -->

                    <div class="row">
                    
                        <div class="col-xl-12">
                            <div class="card">
                                <div class="card-header align-items-center d-flex">
                                    <h4 class="card-title mb-0 flex-grow-1">Brand List</h4>
                                    <div class="d-flex justify-content-end">
                                    <a href="<?php echo e(route('brand.add')); ?>">
                                    <button type="button" class="btn btn-primary d-flex justify-content-end">Add Brand</button>
                                    </a>
                                </div>
                                </div><!-- end card header -->

                                <div class="card-body">
                                    
                                    <div class="live-preview">
                                        <div class="table-responsive">
                                            <table id="example" class="table table-striped table-nowrap align-middle mb-0">
                                                <thead>
                                                    <tr>
                                                        <th scope="col">ID</th>
                                                        <th scope="col">Brand Name</th>
                                                        <th scope="col">Description</th>
                                                        <th scope="col">Brand Logo</th>
                                                        <th scope="col">Status</th>
                                                        <th scope="col">Action</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                <?php if($brand == "" && $brand->isEmpty()): ?>
                                                <tr>
                                                   <td colspan="5" class="text-center">No data found.</td>
                                                </tr>
                                                <?php else: ?>
                                                <?php $__currentLoopData = $brand; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <tr>
                                                        <td class="fw-medium"><?php echo e($key + 1); ?></td>
                                                        <td><?php echo e($item->name); ?></td>
                                                        <td><?php echo e($item->description); ?></td>
                                                        <td>
                                                        <?php if($item->logo): ?>
                                                        <img src="<?php echo e(asset('uploads/brands/' . $item->logo)); ?>" alt="Brand Logo" width="50" height="50">
                                                        <?php else: ?>
                                                        <span class="text-muted">No Image</span>
                                                        <?php endif; ?>
                                                        </td>
                                                        <td><span class="badge bg-primary"><?php echo e($item->status); ?></span></td>
                                                        <td><div class="hstack gap-3 flex-wrap">
                                                            <a href="<?php echo e(route('brand.edit', $item->id)); ?>" class="link-success fs-15"><i class="ri-edit-2-line"></i></a>
                                                            <a href="javascript:void(0);" 
                                                            class="link-danger fs-15 delete-category" 
                                                            data-id="<?php echo e($item->id); ?>">
                                                            <i class="ri-delete-bin-line"></i>
                                                            </a>
                                                            <!-- <a href="<?php echo e(route('category.delete', $item->id)); ?>"  class="link-danger fs-15"><i class="ri-delete-bin-line"></i></a> -->
                                                        </div></td>
                                                    </tr>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>    
                                                <?php endif; ?>       
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                    
                                </div><!-- end card-body -->
                            </div><!-- end card -->
                        </div>
                        <!-- end col -->
                    </div>
                </div>
            </div>
            <!-- End Page-content -->
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
document.addEventListener('DOMContentLoaded', function () {
    const deleteButtons = document.querySelectorAll('.delete-category');

    deleteButtons.forEach(button => {
        button.addEventListener('click', function () {
            const categoryId = this.getAttribute('data-id');
            Swal.fire({
                title: 'Are you sure?',
                text: "This action cannot be undone!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, delete it!'
            }).then((result) => {
                if (result.isConfirmed) {
                    let deleteUrl = "<?php echo e(route('brand.delete', ':id')); ?>".replace(':id', categoryId);
                    window.location.href = deleteUrl;
                }
            });
        });
    });
});
</script>

<?php echo $__env->make('admin.layouts.footer', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<!-- DataTables JS -->
    <script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>

    <script>
    $(document).ready(function () {
        $('#example').DataTable({
        responsive: true
        });
    });
    </script>


<?php /**PATH /home/hubto/public_html/griffin/resources/views/admin/brand-list.blade.php ENDPATH**/ ?>