<?php echo $__env->make('layouts.header', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<main>
    <div class="mb-4 pb-4"></div>
    <section class="my-account container">
      <h2 class="page-title">Orders</h2>
      <div class="row">
        <div class="col-lg-3">
          <ul class="account-nav">
            <li><a href="javascript:void(0);" class="menu-link menu-link_us-s">Dashboard</a></li>
            <li><a href="javascript:void(0);" class="menu-link menu-link_us-s">Orders</a></li>
            <li><a href="javascript:void(0);" class="menu-link menu-link_us-s">Addresses</a></li>
            <li><a href="javascript:void(0);" class="menu-link menu-link_us-s">Account Details</a></li>
            <li><a href="javascript:void(0);" class="menu-link menu-link_us-s menu-link_active">Wishlist</a></li>
          </ul>
        </div>
        <div class="col-lg-9">
          <div class="page-content my-account__orders-list">
            <table class="orders-table">
              <thead>
                <tr>
                  <th>Order</th>
                  <th>Date</th>
                  <th>Status</th>
                  <th>Total</th>
                  <th>Actions</th>
                </tr>
              </thead>
              <tbody>
              
              <!-- <?php $__empty_1 = true; $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                  <tr>
                      <td><?php echo e($order->order_id); ?></td>
                      <td><?php echo e(\Carbon\Carbon::parse($order->created_at)->format('F j, Y')); ?></td>
                      <td><?php echo e(ucfirst($order->order_status ?? 'Pending')); ?></td>
                      <td>
                          Rs. <?php echo e(number_format($order->total, 2)); ?>

                          for <?php echo e($order->qty); ?> <?php echo e(Str::plural('item', $order->qty)); ?>

                      </td>
                      <td>
                          <a href="<?php echo e(route('order.details', $order->id)); ?>" class="btn btn-primary">VIEW</a>
                      </td>
                  </tr>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                  <tr>
                      <td colspan="5" class="text-center">You have no orders yet.</td>
                  </tr>
              <?php endif; ?> -->
              <tbody id="order-list">
                  <?php echo $__env->make('partials.orders_rows', ['orders' => $orders], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
              </tbody>
            </table>
          </div>
          <?php if($orders->hasMorePages()): ?>
              <div class="text-center mt-3">
                  <button id="load-more" class="btn btn-outline-primary" data-next-page="<?php echo e($orders->currentPage() + 1); ?>">Load More</button>
              </div>
              <?php endif; ?>
        </div>
        
      </div>
    </section>
  </main>

  <div class="mb-5 pb-xl-5"></div>
<?php echo $__env->make('layouts.footer', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
    $(document).on('click', '#load-more', function () {
        let button = $(this);
        let page = button.data('next-page');

        $.ajax({
            url: "<?php echo e(route('my.order')); ?>",
            type: "GET",
            data: { page: page },
            beforeSend: function () {
                button.text('Loading...');
            },
            success: function (data) {
                $('#order-list').append(data);
                let nextPage = page + 1;
                button.data('next-page', nextPage);

                // If response is empty (no more rows)
                if (data.trim() === '') {
                    button.remove();
                } else {
                    button.text('Load More');
                }
            },
            error: function () {
                alert('Could not load more orders.');
                button.text('Load More');
            }
        });
    });
</script>

<?php /**PATH /home/hubto/public_html/griffin/resources/views/order.blade.php ENDPATH**/ ?>