<?php echo $__env->make('admin.layouts.header', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<?php echo $__env->make('admin.layouts.sidebar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
        <!-- ============================================================== -->
        <!-- Start right Content here -->
        <!-- ============================================================== -->
        <div class="main-content">

            <div class="page-content">
                <div class="container-fluid">

                    <!-- start page title -->
                    <div class="row">
                        <div class="col-12">
                            <div class="page-title-box d-sm-flex align-items-center justify-content-between bg-galaxy-transparent">
                                <h4 class="mb-sm-0">Add Products</h4>

                                <div class="page-title-right">
                                    <ol class="breadcrumb m-0">
                                        <li class="breadcrumb-item"><a href="javascript: void(0);">Forms</a></li>
                                        <li class="breadcrumb-item active">Add Products</li>
                                    </ol>
                                </div>

                            </div>
                        </div>
                    </div>
                    <!-- end page title -->

                    <div class="row">
                        <div class="col-lg-12">
                            <div class="card">
                                <div class="card-header align-items-center d-flex">
                                    <h4 class="card-title mb-0 flex-grow-1">Input Example</h4>
                                    
                                </div><!-- end card header -->
                                <form action="<?php echo e(route('product.save')); ?>" method="post" enctype="multipart/form-data">
                                <?php echo csrf_field(); ?>
                                <div class="card-body">
                                    <div class="live-preview">
                                        <div class="row gy-4">
                                                                                      
                                
                                            <div class="col-xxl-3 col-md-6">
                                                <div>
                                                    <label for="categorySelect" class="form-label">Category</label>
                                                    <select name="category_id" class="form-select" id="categorySelect">
                                                        <option value="">Select Category</option>
                                                        <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <!-- <option value="<?php echo e($category->id); ?>"><?php echo e($category->name); ?></option> -->
                                                            <option value="<?php echo e($category->id); ?>"
                                                                <?php echo e(old('category_id') == $category->id ? 'selected' : ''); ?>>
                                                                <?php echo e($category->name); ?>

                                                            </option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </select>
                                                    <?php if($errors->has('category_id')): ?>
                                                    <p class="text-danger"><?php echo e($errors->first('category_id')); ?></p>
                                                    <?php endif; ?>    
                                                </div>
                                            </div>
                                            <div class="col-xxl-3 col-md-6">
                                                <div>
                                                    <label for="subCategorySelect" class="form-label">Sub Category</label>
                                                    <select name="sub_category_id" class="form-select" id="subCategorySelect">
                                                        <option value="">Select Sub Category</option>
                                                        
                                                    </select> 
                                                    <?php if($errors->has('sub_category_id')): ?>
                                                    <p class="text-danger"><?php echo e($errors->first('sub_category_id')); ?></p>
                                                    <?php endif; ?>  
                                                </div>
                                            </div>
                                            <div class="col-xxl-3 col-md-6">
                                                <div>
                                                    <label for="childCategorySelect" class="form-label">Child Category</label>
                                                    <select name="child_category_id" class="form-select" id="childCategorySelect">
                                                        <option value="">Select Child Category</option>    
                                                    </select> 
                                                    <?php if($errors->has('child_category_id')): ?>
                                                    <p class="text-danger"><?php echo e($errors->first('child_category_id')); ?></p>
                                                    <?php endif; ?>  
                                                </div>
                                            </div>
                                            <div class="col-xxl-3 col-md-6">
                                                <div>
                                                    <label for="brandSelect" class="form-label">Brands</label>
                                                    <select name="brand_id" class="form-select" id="brandSelect">
                                                        <option value="">Select Brand</option>
                                                        <?php $__currentLoopData = $brands; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $brand): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <option value="<?php echo e($brand->id); ?>"
                                                            <?php echo e(old('brand_id') == $brand->id ? 'selected' : ''); ?>>
                                                                <?php echo e($brand->name); ?>

                                                            </option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </select>
                                                    <?php if($errors->has('brand_id')): ?>
                                                    <p class="text-danger"><?php echo e($errors->first('brand_id')); ?></p>
                                                    <?php endif; ?>   
                                                </div>
                                            </div>
                                            <!--end col-->
                                            <div class="col-xxl-3 col-md-6">
                                                <div>
                                                    <label for="name" class="form-label">Name</label>
                                                    <input type="text" name="name" class="form-control" id="name" placeholder="Enter Name" value="<?php echo e(old('name')); ?>">
                                                    <?php if($errors->has('name')): ?>
                                                    <p class="text-danger"><?php echo e($errors->first('name')); ?></p>
                                                    <?php endif; ?> 
                                                </div>
                                            </div>
                                            <!--end col-->
                                            <div class="col-xxl-3 col-md-6">
                                                <div>
                                                    <label for="mrp" class="form-label">MRP</label>
                                                    <input type="number" name="mrp" class="form-control" id="placeholderInput" placeholder="Enter MRP" value="<?php echo e(old('mrp')); ?>">
                                                    <?php if($errors->has('mrp')): ?>
                                                    <p class="text-danger"><?php echo e($errors->first('mrp')); ?></p>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                            <!--end col-->
                                            <div class="col-xxl-3 col-md-6">
                                                <div>
                                                    <label for="discount" class="form-label">Discount</label>
                                                    <input type="number" name="discount" class="form-control" step="0.01" id="discount" placeholder="Enter Discount" value="<?php echo e(old('discount')); ?>">
                                                    <?php if($errors->has('discount')): ?>
                                                    <p class="text-danger"><?php echo e($errors->first('discount')); ?></p>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                            <!--end col-->
                                            <div class="col-xxl-3 col-md-6">
                                                <div>
                                                    <label for="selling_price" class="form-label">Selling Price</label>
                                                    <input type="number" name="selling_price" class="form-control" step="0.01" id="selling_price" placeholder="Enter Selling Price" value="<?php echo e(old('selling_price')); ?>">
                                                    <?php if($errors->has('selling_price')): ?>
                                                    <p class="text-danger"><?php echo e($errors->first('selling_price')); ?></p>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                            <!--end col-->
                                    
                                            <div class="col-xxl-3 col-md-6">
                                                <div>
                                                    <label for="size" class="form-label">Size</label>
                                                    <input type="text" name="size" class="form-control" id="size" placeholder="Enter Size" value="<?php echo e(old('size')); ?>">
                                                    <?php if($errors->has('size')): ?>
                                                    <p class="text-danger"><?php echo e($errors->first('size')); ?></p>
                                                    <?php endif; ?>
                                                </div>
                                            </div>

                                            <div class="col-xxl-3 col-md-6">
                                                <div>
                                                    <label for="color" class="form-label">Color</label>
                                                    <input type="text" name="color" class="form-control" id="color" placeholder="Enter Color" value="<?php echo e(old('color')); ?>">
                                                    <?php if($errors->has('color')): ?>
                                                    <p class="text-danger"><?php echo e($errors->first('color')); ?></p>
                                                    <?php endif; ?>
                                                </div>
                                            </div>

                                            <div class="col-xxl-3 col-md-6">
                                                <div>
                                                    <label for="sku" class="form-label">SKU ID</label>
                                                    <input type="text" name="sku" class="form-control" id="sku" placeholder="Enter SKU ID" value="<?php echo e(old('sku')); ?>">
                                                    <?php if($errors->has('sku')): ?>
                                                    <p class="text-danger"><?php echo e($errors->first('sku')); ?></p>
                                                    <?php endif; ?>
                                                </div>
                                            </div>

                                            <div class="col-xxl-3 col-md-6">
                                                <div>
                                                    <label for="hsn_code" class="form-label">HSN Code</label>
                                                    <input type="number" name="hsn_code" class="form-control" id="hsn_code" placeholder="Enter HSN Code" value="<?php echo e(old('hsn_code')); ?>">
                                                    <?php if($errors->has('hsn_code')): ?>
                                                    <p class="text-danger"><?php echo e($errors->first('hsn_code')); ?></p>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                            <div class="col-xxl-3 col-md-6">
                                                <div>
                                                    <label for="stock" class="form-label">Stock</label>
                                                    <input type="number" name="stock" class="form-control" id="stock" placeholder="Enter Stock" value="<?php echo e(old('stock')); ?>">
                                                    <?php if($errors->has('stock')): ?>
                                                    <p class="text-danger"><?php echo e($errors->first('stock')); ?></p>
                                                    <?php endif; ?>
                                                </div>
                                            </div>


                                            <!-- add variant type -->
                                            <!--<input type="hidden" name="product_variant_type_id" id="selected_variant_type_id" value="<?php echo e(old('product_variant_type_id')); ?>">-->
                                            <!--<div class="dropdown col-xxl-3 col-md-6" style = "margin-top: 50px">-->
                                            <!--    <button class="btn btn btn-light text-dark w-100 dropdown-toggle" type="button" id="variantDropdown" data-bs-toggle="dropdown" aria-expanded="false">-->
                                            <!--        Select Variant Type-->
                                            <!--    </button>-->
                                            <!--    <ul class="dropdown-menu" aria-labelledby="variantDropdown" id="variant_type_menu">-->
                                            <!--        <?php $__currentLoopData = $variantTypes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $variant): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>-->
                                            <!--            <li>-->
                                            <!--                <a class="dropdown-item variant-option" href="#" data-id="<?php echo e($variant->id); ?>" data-input-type="<?php echo e($variant->input_type); ?>">-->
                                            <!--                    <?php echo e($variant->variation_type); ?>-->
                                            <!--                </a>-->
                                            <!--            </li>-->
                                            <!--        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>-->
                                            <!--        <li><hr class="dropdown-divider"></li>-->
                                            <!--        <li class="px-3">-->
                                            <!--            <input type="text" id="variant_value_input" class="form-control mb-2" placeholder="variant value">-->
                                            <!--            <button class="btn btn-primary w-100" id="save_variant_value">Save Variant Value</button>-->
                                            <!--        </li>-->
                                            <!--    </ul>-->
                                            <!--    <?php if($errors->has('product_variant_type_id')): ?>-->
                                            <!--    <p class="text-danger"><?php echo e($errors->first('product_variant_type_id')); ?></p>-->
                                            <!--<?php endif; ?>-->
                                            <!--</div>-->
                                            

                                        <div class="row gy-4">
                                            <div class="col-xxl-6 col-md-6">
                                                <div>
                                                    <label for="product_highlights" class="form-label">Product Highlights</label>
                                                    <input name="product_highlights" class="form-control ck-editor" id="product_highlights" placeholder="Product Highlights" value="<?php echo e(old('product_highlights')); ?>">
                                                    <?php if($errors->has('product_highlights')): ?>
                                                    <p class="text-danger"><?php echo e($errors->first('product_highlights')); ?></p>
                                                    <?php endif; ?>
                                                </div>
                                            </div>

                                            <div class="col-xxl-6 col-md-6">
                                                <div>
                                                    <label for="product_description" class="form-label">Product Description</label>
                                                    <input name="product_description" class="form-control ck-editor" id="product_description" placeholder="Product Description" value="<?php echo e(old('product_description')); ?>">
                                                    <?php if($errors->has('product_description')): ?>
                                                    <p class="text-danger"><?php echo e($errors->first('product_description')); ?></p>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                        </div>
                                        <!-- </div> -->

                                            <div class="row gy-4">
                                                
                                                <h4 style="margin-top: 46px">Dimensions</h4>
                                                <div class="col-xxl-3 col-md-6">
                                                    <div>
                                                        <label for="iconInput" class="form-label">Length</label>
                                                        <div class="form-icon">
                                                            <input type="number" step="0.01" name="length" class="form-control form-control-icon" id="iconInput" placeholder="Length (cm)" value="<?php echo e(old('length')); ?>">
                                                            <?php if($errors->has('length')): ?>
                                                            <p class="text-danger"><?php echo e($errors->first('length')); ?></p>
                                                            <?php endif; ?>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-xxl-3 col-md-6">
                                                    <div>
                                                        <label for="iconInput" class="form-label">Breadth</label>
                                                        <div class="form-icon">
                                                            <input type="number" step="0.01" name="breadth" class="form-control form-control-icon" id="breadth" placeholder="Breadth (cm)" value="<?php echo e(old('breadth')); ?>">
                                                            <?php if($errors->has('breadth')): ?>
                                                            <p class="text-danger"><?php echo e($errors->first('breadth')); ?></p>
                                                            <?php endif; ?> 
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-xxl-3 col-md-6">
                                                    <div>
                                                        <label for="iconInput" class="form-label">Height</label>
                                                        <div class="form-icon">
                                                            <input type="number" step="0.01" name="height" class="form-control form-control-icon" id="height" placeholder="Height (cm)" value="<?php echo e(old('height')); ?>">
                                                            <?php if($errors->has('height')): ?>
                                                            <p class="text-danger"><?php echo e($errors->first('height')); ?></p>
                                                            <?php endif; ?>
                                                            
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-xxl-3 col-md-6">
                                                    <div>
                                                        <label for="iconInput" class="form-label">Weight</label>
                                                        <div class="form-icon">
                                                            <input type="number" step="0.01" name="weight" class="form-control form-control-icon" id="weight" placeholder="Weight (g)" value="<?php echo e(old('weight')); ?>">
                                                            <?php if($errors->has('weight')): ?>
                                                            <p class="text-danger"><?php echo e($errors->first('weight')); ?></p>
                                                            <?php endif; ?>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <hr>
                                                <div class="col-xxl-3 col-md-6">
                                                    <div>
                                                        <label for="country_of_origin" class="form-label">Country Of Origin</label>
                                                        <select name="country_of_origin" class="form-select" id="country_of_origin">
                                                            <option value="">Select Country Of Origin</option>
                                                            <option value="India" <?php echo e(old('country_of_origin') == 'India' ? 'selected' : ''); ?>>India</option>
                                                            <option value="USA" <?php echo e(old('country_of_origin') == 'USA' ? 'selected' : ''); ?>>USA</option>    
                                                        </select> 
                                                        <?php if($errors->has('country_of_origin')): ?>
                                                            <p class="text-danger"><?php echo e($errors->first('country_of_origin')); ?></p>
                                                        <?php endif; ?>  
                                                    </div>
                                                </div>

                                                
                                                <div class="col-xxl-3 col-md-6">
                                                <div>
                                                    <label for="manufacturer_details" class="form-label">Manufacturer's Details</label>
                                                    <textarea name="manufacturer_details" class="form-control" id="manufacturer_details" placeholder="Manufacturer's Details"><?php echo e(old('manufacturer_details')); ?></textarea>
                                                    <?php if($errors->has('manufacturer_details')): ?>
                                                        <p class="text-danger"><?php echo e($errors->first('manufacturer_details')); ?></p>
                                                    <?php endif; ?> 
                                                </div>
                                                </div>

                                                <div class="col-xxl-3 col-md-6">
                                                <div>
                                                    <label for="importer_details" class="form-label">Importer's Details</label>
                                                    <textarea name="importer_details" class="form-control" id="importer_details" placeholder="Importer's Details"><?php echo e(old('importer_details')); ?></textarea>
                                                    <?php if($errors->has('importer_details')): ?>
                                                        <p class="text-danger"><?php echo e($errors->first('importer_details')); ?></p>
                                                    <?php endif; ?> 
                                                </div>
                                                </div>

                                                <div class="col-xxl-3 col-md-6">
                                                    <div>
                                                        <label for="packer_details" class="form-label">Packer's Details</label>
                                                        <textarea name="packer_details" class="form-control" id="packer_details" placeholder="Packer's Details"><?php echo e(old('packer_details')); ?></textarea>
                                                        <?php if($errors->has('packer_details')): ?>
                                                            <p class="text-danger"><?php echo e($errors->first('packer_details')); ?></p>
                                                        <?php endif; ?> 
                                                    </div>
                                                </div>



                                                <hr>

                                                <h4>SEO Terms</h4>
                                                <div class="col-xxl-3 col-md-6">
                                                    <div>
                                                        <label for="meta_title" class="form-label">Meta Title</label>
                                                        <div class="form-icon">
                                                            <input type="text" name="meta_title" class="form-control form-control-icon" id="weight" placeholder="Meta Title" value="<?php echo e(old('meta_title')); ?>">
                                                            <?php if($errors->has('meta_title')): ?>
                                                            <p class="text-danger"><?php echo e($errors->first('meta_title')); ?></p>
                                                            <?php endif; ?>
                                                        </div>
                                                    </div>
                                                </div>

                                                <div class="col-xxl-3 col-md-6">
                                                    <div>
                                                        <label for="meta_description" class="form-label">Meta Description</label>
                                                        <textarea name="meta_description" class="form-control" id="meta_description" placeholder="Meta Description"><?php echo e(old('meta_description')); ?></textarea>
                                                        <?php if($errors->has('meta_description')): ?>
                                                            <p class="text-danger"><?php echo e($errors->first('meta_description')); ?></p>
                                                        <?php endif; ?>
                                                    </div>
                                                </div>

                                                <div class="col-xxl-3 col-md-6">
                                                    <div>
                                                        <label for="meta_keywords" class="form-label">Meta Keywords</label>
                                                        <textarea name="meta_keywords" class="form-control" id="meta_keywords" placeholder="Meta Keywords"><?php echo e(old('meta_keywords')); ?></textarea>
                                                        <?php if($errors->has('meta_keywords')): ?>
                                                            <p class="text-danger"><?php echo e($errors->first('meta_keywords')); ?></p>
                                                        <?php endif; ?>
                                                    </div>
                                                </div>

                                                <hr>
                                                <div class="col-xxl-3 col-md-6">
                                                    <div>
                                                        <label for="meta_title" class="form-label">Product Tags</label>
                                                        <div class="form-icon">
                                                            <input type="text" name="tags" class="form-control form-control-icon" id="weight" placeholder="Product Tags (comma-separated)" value="<?php echo e(old('tags')); ?>">
                                                            <?php if($errors->has('tags')): ?>
                                                            <p class="text-danger"><?php echo e($errors->first('tags')); ?></p>
                                                            <?php endif; ?>
                                                        </div>
                                                    </div>
                                                </div>

                                                <div class="col-xxl-3 col-md-6">
                                                    <div>
                                                        <label for="note" class="form-label">Note</label>
                                                        <textarea name="note" class="form-control" id="note" placeholder="Note"><?php echo e(old('note')); ?></textarea>
                                                        <?php if($errors->has('note')): ?>
                                                            <p class="text-danger"><?php echo e($errors->first('note')); ?></p>
                                                        <?php endif; ?>
                                                    </div>
                                                </div>

                                                <div class="col-xxl-3 col-md-6">
                                                    <div>
                                                        <label for="statusSelect" class="form-label">Status</label>
                                                        <select name="status" class="form-select" id="statusSelect">
                                                            <option value="">Select Status</option>
                                                            <option value="active" <?php echo e(old('status') == 'active' ? 'selected' : ''); ?>>Active</option>
                                                            <option value="inactive" <?php echo e(old('status') == 'inactive' ? 'selected' : ''); ?>>Inactive</option>
                                                        </select> 
                                                        <?php if($errors->has('status')): ?>
                                                            <p class="text-danger"><?php echo e($errors->first('status')); ?></p>
                                                        <?php endif; ?>  
                                                    </div>
                                                </div>

                                                <div class="col-xxl-3 col-md-6">
                                                    <div>
                                                        <label for="featured_image" class="form-label">Featured Image</label>
                                                        <input type="file" name="featured_image" class="form-control" id="featured_image" value="<?php echo e(old('featured_image')); ?>">
                                                        <?php if($errors->has('featured_image')): ?>
                                                            <p class="text-danger"><?php echo e($errors->first('featured_image')); ?></p>
                                                        <?php endif; ?>  
                                                    </div>
                                                </div>

                                                <div class="col-xxl-3 col-md-6">
                                                    <div>
                                                        <label for="bulk_images" class="form-label">Bulk Images</label>
                                                        <input type="file" name="bulk_images[]" class="form-control" id="bulk_images" multiple>
                                                        <?php if($errors->has('bulk_images')): ?>
                                                            <p class="text-danger"><?php echo e($errors->first('bulk_images')); ?></p>
                                                        <?php endif; ?> 
                                                    </div>
                                                </div>
                                                
                                                <div style="text-align: center;">
                                                    <button type="submit" class="btn btn-primary">Submit</button>
                                                </div>
                                            </div>                                            
                            
                                        </div>
                                        <!--end row-->
                                    </div>
                                    
                                </div>
                                </form>
                            </div>
                        </div>
                        <!--end col-->
                    </div>
                    <!--end row-->
                    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
                    <script>
                    
                    const BASE_URL = "<?php echo e(env('APP_URL')); ?>";
                    
                    $(document).ready(function () {
                        $('select[name="category_id"]').on('change', function () {
                            let categoryId = $(this).val();
                            if (categoryId) {
                                $.get(`${BASE_URL}/get-subcategories/${categoryId}`, function (data) {
                                    $('select[name="sub_category_id"]').empty().append('<option value="">-- Select --</option>');
                                    $.each(data, function (id, name) {
                                        $('select[name="sub_category_id"]').append(`<option value="${id}">${name}</option>`);
                                    });
                                    $('select[name="child_category_id"]').empty().append('<option value="">-- Select --</option>');
                                });
                            }
                        });

                        $('select[name="sub_category_id"]').on('change', function () {
                            let subcatId = $(this).val();
                            if (subcatId) {
                                $.get(`${BASE_URL}/get-childcategories/${subcatId}`, function (data) {
                                    $('select[name="child_category_id"]').empty().append('<option value="">-- Select --</option>');
                                    $.each(data, function (id, name) {
                                        $('select[name="child_category_id"]').append(`<option value="${id}">${name}</option>`);
                                    });
                                });
                            }
                        });
                    });
                    </script>

                    <script src="https://cdn.ckeditor.com/ckeditor5/39.0.1/classic/ckeditor.js"></script>
                    <script>
                        document.querySelectorAll('.ck-editor').forEach(editorElement => {
                            ClassicEditor
                                .create(editorElement)
                                .catch(error => {
                                    console.error(error);
                                });
                        });
                    </script>

<!------- for amount calculation  -->

        <script>
            document.addEventListener('DOMContentLoaded', function () {
                const mrpInput = document.querySelector('input[name="mrp"]');
                const discountInput = document.querySelector('input[name="discount"]');
                const sellingPriceInput = document.querySelector('input[name="selling_price"]');
        
                function calculateSellingPrice() {
                    const mrp = parseFloat(mrpInput.value);
                    const discount = parseFloat(discountInput.value);
                    if (!isNaN(mrp) && !isNaN(discount)) {
                        const sellingPrice = mrp - (mrp * discount / 100);
                        sellingPriceInput.value = sellingPrice.toFixed(2);
                    }
                }
        
                function calculateDiscount() {
                    const mrp = parseFloat(mrpInput.value);
                    const sellingPrice = parseFloat(sellingPriceInput.value);
                    if (!isNaN(mrp) && !isNaN(sellingPrice) && mrp !== 0) {
                        const discount = ((mrp - sellingPrice) / mrp) * 100;
                        discountInput.value = discount.toFixed(2);
                    }
                }
        
                // Event listeners
                mrpInput.addEventListener('input', function () {
                    if (discountInput.value) {
                        calculateSellingPrice();
                    } else if (sellingPriceInput.value) {
                        calculateDiscount();
                    }
                });
        
                discountInput.addEventListener('input', function () {
                    if (mrpInput.value) {
                        calculateSellingPrice();
                    }
                });
        
                sellingPriceInput.addEventListener('input', function () {
                    if (mrpInput.value) {
                        calculateDiscount();
                    }
                });
            });
        </script>






<script>
    $(document).ready(function () {
        // Restore old selected variant type on load
        let oldVariantId = $('#selected_variant_type_id').val();
        if (oldVariantId) {
            let selectedOption = $('.variant-option[data-id="' + oldVariantId + '"]');
            if (selectedOption.length) {
                $('#variantDropdown').text(selectedOption.text());
                $('.variant-option').removeClass('active');
                selectedOption.addClass('active');
            }
        }

        // Handle variant selection
        $('.variant-option').on('click', function (e) {
            e.preventDefault();

            let variantId = $(this).data('id');
            let variantText = $(this).text();

            $('#variantDropdown').text(variantText); // update button
            $('#selected_variant_type_id').val(variantId); // update hidden input

            $('.variant-option').removeClass('active');
            $(this).addClass('active');
        });

        // Handle save variant value via AJAX
        $('#save_variant_value').on('click', function (e) {
            e.preventDefault();

            let value = $('#variant_value_input').val();
            let variantTypeId = $('#selected_variant_type_id').val();

            if (!variantTypeId || !value) {
                alert('Please select variant type and enter a value.');
                return;
            }

            // Set CSRF for AJAX
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $.ajax({
                url: "<?php echo e(route('variant.value.store')); ?>",
                type: "POST",
                data: {
                    product_variant_type_id: variantTypeId,
                    name: value
                },
                success: function (response) {
                    if (response.status === 'true') {
                        alert('Variant value saved successfully!');
                        $('#variant_value_input').val('');
                    } else {
                        alert('Error: ' + response.message);
                    }
                },
                error: function (xhr) {
                    console.error(xhr.responseText);
                    alert('AJAX error occurred. Check console.');
                }
            });
        });
    });
</script>





<?php echo $__env->make('admin.layouts.footer', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>                   <?php /**PATH /home/hubto/public_html/griffin/resources/views/admin/products/product-add.blade.php ENDPATH**/ ?>