<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\MenuController;
use App\Http\Controllers\CartController;
use App\Http\Controllers\userController;
use App\Http\Controllers\OrderController;
use App\Http\Middleware\UserAuthenticate;

Route::get('/', function () {
    return view('index');
});


Route::get('/user-login', [userController::class, 'userLogin'])->name('user.login');
Route::get('/user-register', [userController::class, 'userRegister'])->name('user.register');
Route::post('/user-login-save', [userController::class, 'userLoginSave'])->name('user.login.save');
Route::post('/user-register-save', [userController::class, 'userRegisterSave'])->name('user.register.save');
Route::get('/user-logout', [userController::class, 'logout'])->name('user.logout');

Route::middleware(UserAuthenticate::class)->group(function () {

Route::post('/update-password', [UserController::class, 'updatePassword'])->name('update.password');
Route::get('/change-password', [UserController::class, 'changePassword'])->name('change.password');    
Route::get('/my-account', [userController::class, 'myAccount'])->name('my.account');
Route::post('/update-account/{user_id}', [userController::class, 'updateAccount'])->name('update.account');

Route::get('/verify-otp-form', [userController::class, 'verifyOtpForm'])->name('verify.otp.form');
Route::post('/verify-otp', [userController::class, 'verifyOtp'])->name('verify.otp');
Route::get('/my-order', [OrderController::class, 'myOrder'])->name('my.order');
Route::get('/order-details/{id}', [OrderController::class, 'orderDetails'])->name('order.details');

});

Route::get('/menu-builder', [MenuController::class, 'index'])->name('menu.builder');
Route::post('/menu-update-order', [MenuController::class, 'updateOrder'])->name('menu.update.order');

Route::get('/collections/{slug}/{sub_cat?}/{child_cat?}', [HomeController::class, 'newArrivals'])->name('collections.category');
Route::get('/new-arrivals', [HomeController::class, 'newArrivals'])->name('new.arrivals');
Route::get('/search-products', [HomeController::class, 'searchProducts'])->name('search.products');

Route::get('/about', [HomeController::class, 'about'])->name('about');
Route::get('/contact', [HomeController::class, 'contact'])->name('contact');
Route::get('/faq', [HomeController::class, 'faq'])->name('faq');
Route::get('/terms-&-conditions', [HomeController::class, 'termsConditions'])->name('terms.conditions');
Route::get('/shipping-policy', [HomeController::class, 'shippingPolicy'])->name('shipping.policy');
Route::get('/refund-policy', [HomeController::class, 'refundPolicy'])->name('refund.policy');
Route::get('/sitemap', [HomeController::class, 'sitemap'])->name('sitemap');
Route::get('/termsofuse', [HomeController::class, 'termsofuse'])->name('termsofuse');
Route::get('/privacy-policy', [HomeController::class, 'privacyPolicy'])->name('privacy.policy');
Route::get('/products/{slug}', [HomeController::class, 'product'])->name('products');
Route::get('/product/filter-by-size', [HomeController::class, 'getProductsBySize'])->name('products.filterBySize');
// Route::get('/product-detail', [HomeController::class, 'getProductsDetail'])->name('product.detail');

Route::get('/cart', [CartController::class, 'cart'])->name('cart');
// Route::post('/apply-coupon', [CartController::class, 'applyCoupon'])->name('apply.coupon');
Route::get('/add-cart', [CartController::class, 'addCart'])->name('add.cart');
Route::put('/cart/update/{id}', [CartController::class, 'updateCart'])->name('cart.update');
Route::get('/delete-cart/{id}', [CartController::class, 'deleteCart'])->name('delete.cart');

Route::get('/search-product', [HomeController::class, 'searchProduct']);

Route::get('/shop-checkout', [HomeController::class, 'shopCheckout'])->name('shop.checkout');
// Route::get('/shop-checkout/{user_id}', [HomeController::class, 'shopCheckout'])->name('shop.checkout');
Route::post('/save-order', [OrderController::class, 'saveOrder'])->name('save.order');

