@include('layouts.header')
    <main>
    <div class="mb-4 pb-4"></div>
    <section class="shop-checkout container mb-5">
      <h2 class="page-title">Shipping and Checkout</h2>
      <!-- <div class="checkout-steps">
        <a href="#" class="checkout-steps__item active">
          <span class="checkout-steps__item-number">01</span>
          <span class="checkout-steps__item-title">
            <span>Shopping Bag</span>
            <em>Manage Your Items List</em>
          </span>
        </a>
        <a href="#" class="checkout-steps__item active">
          <span class="checkout-steps__item-number">02</span>
          <span class="checkout-steps__item-title">
            <span>Shipping and Checkout</span>
            <em>Checkout Your Items List</em>
          </span>
        </a>
        <a href="#" class="checkout-steps__item">
          <span class="checkout-steps__item-number">03</span>
          <span class="checkout-steps__item-title">
            <span>Confirmation</span>
            <em>Review And Submit Your Order</em>
          </span>
        </a>
      </div> -->
      
      <form name="checkout-form" action="{{ route('save.order') }}" method="POST">
        @csrf
        <div class="checkout-form">
          
          <div class="billing-info__wrapper">
            @if(session('success'))
                    <div class="alert alert-success" style="padding-top: 10px; padding-bottom: 10px;">
                        {{ session('success') }}
                    </div> 
                  @elseif(session('error'))
                    <div class="alert alert-danger" style="padding-top: 10px; padding-bottom: 10px;">
                        {{ session('error') }}
                    </div>
            @endif
            <h4>BILLING DETAILS</h4>
            <div class="row">
              <div class="col-md-12">

                <input name="user_id" type="hidden" value = "{{ $user_id }}">
                <input name="total" type="hidden" value = "{{ $total }}">
                <input name="coupon_discount" type="hidden" value = "{{ $coupon_discount }}">

                <div class="form-floating my-3">
                  <input name="first_name" type="text" class="form-control" id="checkout_first_name" placeholder="First Name" value="{{ old('first_name', $user->name ?? '') }}">
                  <label for="checkout_first_name">Name</label>
                  @if($errors->has('first_name'))
                    <p class="text-danger">{{ $errors->first('first_name') }}</p>
                  @endif
                </div>
              </div>
              <div class="col-md-12">
                <div class="mt-3">
                  <textarea cols="30" rows="4" name="address" type="text" class="form-control" placeholder="Street Address *" value="{{ old('address') }}"></textarea>
                </div>
                @if($errors->has('address'))
                    <p class="text-danger">{{ $errors->first('address') }}</p>
                @endif
                <!-- <div class="form-floating mt-3 mb-3">
                  <input type="text" class="form-control" id="checkout_street_address_2">
                </div> -->
              </div>
              <div class="col-md-12">
                <div class="form-floating my-3">
                  <input name="state" type="text" class="form-control" id="checkout_state" placeholder="State *" value="{{ old('state') }}">
                  <label for="checkout_city">State *</label>
                </div>
                @if($errors->has('state'))
                    <p class="text-danger">{{ $errors->first('state') }}</p>
                @endif
              </div>
              <div class="col-md-12">
                <div class="form-floating my-3">
                  <input name="city" type="text" class="form-control" id="checkout_city" placeholder="Town / City *" value="{{ old('city') }}">
                  <label for="checkout_city">Town / City *</label>
                </div>
                @if($errors->has('city'))
                    <p class="text-danger">{{ $errors->first('city') }}</p>
                @endif
              </div>
              <div class="col-md-12">
                <div class="form-floating my-3">
                  <input name="post_code" type="text" class="form-control" id="checkout_zipcode" placeholder="Postcode / ZIP *" value="{{ old('post_code') }}">
                  <label for="checkout_zipcode">Postcode / ZIP *</label>
                  @if($errors->has('post_code'))
                      <p class="text-danger">{{ $errors->first('post_code') }}</p>
                  @endif
                </div>
              </div>
              <div class="col-md-12">
                <div class="form-floating my-3">
                  <input name="phone" type="tel" class="form-control" id="checkout_phone" placeholder="Phone *" pattern="[0-9]{10}" maxlength="10" value="{{ old('mobile', $user->mobile ?? '') }}">
                  <label for="checkout_phone">Phone *</label>
                  @if($errors->has('phone'))
                     <p class="text-danger">{{ $errors->first('phone') }}</p> 
                  @endif
                </div>
              </div>
              <div class="col-md-12">
                <div class="form-floating my-3">
                  <input name="email" type="email" class="form-control" id="checkout_email" placeholder="Your Mail *" value="{{ old('email', $user->email ?? '') }}">
                  <label for="checkout_email">Your Mail *</label>
                  @if($errors->has('email'))
                     <p class="text-danger">{{ $errors->first('email') }}</p> 
                  @endif
                </div>
              </div>
            </div>
            <div class="col-md-12">
              <div class="mt-3">
                <textarea  name="notes" class="form-control form-control_gray" placeholder="Order Notes (optional)" cols="30" rows="8"></textarea>
              </div>
            </div>
          </div>
          <div class="checkout__totals-wrapper">
            <div class="sticky-content">
            <div class="shopping-cart__totals-wrapper">
              <div class="sticky-content">
                <div class="shopping-cart__totals">
                  <h3>Your Order</h3>
                  <table class="cart-totals">
                    <tbody>
                      <tr>
                        <th>MRP</th>
                          <td>Rs. {{ $subtotalmrp ?? '' }}</td>
                      </tr>
                      <tr>
                        <th>Discount On MRP</th>                  
                        <td><span class="money price pr-color">Rs. {{ $subtotalmrp - $sub_total ?? '' }}</span></td>
                      </tr>
                      
                      @if($coupon_discount != 0 )
                      <tr>
                        <th>Coupon Discount</th>
                        <td>Rs. {{ $coupon_discount ?? ''}} ({{ $coupon }})</td>
                      </tr>
                      @endif
                      
                      <tr>
                        <th>Total</th>
                        <td>Rs. {{ $total }}</td>
                      </tr>
                    </tbody>
                  </table>
                </div>
              </div>
            </div>
              
              <div class="checkout__payment-methods">
                
                <div class="form-check">
                  <input class="form-check-input form-check-input_fill" type="radio" name="payment_method" value="Cash on delivery" id="checkout_payment_method_3">
                  <label class="form-check-label" for="checkout_payment_method_3">
                    Cash on delivery
                    <span class="option-detail d-block">
                      Phasellus sed volutpat orci. Donec dignissim viverra nunc, ut aliquet magna posuere eget.
                    </span>
                  </label>
                </div>
                
                <div class="policy-text">
                  Your personal data will be used to process your order,<a href="#" target="_blank">privacy policy</a>.
                </div>
              </div>
              <button class="btn btn-primary btn-checkout">PLACE ORDER</button>
            </div>
          </div>
        </div>
      </form>
    </section>
  </main>
@include('layouts.footer')

<script>
  $('#checkout_zipcode').on('keyup', function () {
    let pincode = $(this).val();

    if (pincode.length === 6) {
        $.ajax({
            url: "https://api.postalpincode.in/pincode/" + pincode,
            method: "GET",
            success: function (response) {
                if (response[0].Status === "Success") {
                    let postOffice = response[0].PostOffice[0];
                    $('#checkout_city').val(postOffice.District);
                    $('#checkout_state').val(postOffice.State);
                } else {
                    $('#checkout_city').val('');
                    $('#checkout_state').val('');
                    alert("Invalid Pincode");
                }
            },
            error: function () {
                alert("Unable to fetch location data.");
            }
        });
    }
});

</script>
