@include('layouts.header')
   <main>
    <section class="full-width_padding">
      <div class="full-width_border border-2" style="border-color: #f5e6e0;">
        <div class="shop-banner position-relative ">
          <div class="background-img" style="background-color: #f5e6e0;">
            
            <img loading="lazy" src="{{ asset('assets/images/shop/shop_banner_2.png') }}" width="1759" height="420" alt="Pattern" class="slideshow-bg__img object-fit-cover">
            
          </div>
          
        </div>
      </div>
    </section>

    <div class="mb-4 pb-lg-3"></div>

    <section class="shop-main container d-flex">
      <div class="shop-sidebar side-sticky bg-body" id="shopFilter">
        <div class="aside-header d-flex d-lg-none align-items-center">
          <h3 class="text-uppercase fs-6 mb-0">Filter By</h3>
          <button class="btn-close-lg js-close-aside btn-close-aside ms-auto"></button>
        </div><!-- /.aside-header -->

        <div class="pt-4 pt-lg-0"></div>
        <div class="accordion" id="color-filters">
          <div class="accordion-item mb-4 pb-3">
            <h5 class="accordion-header" id="accordion-heading-1">
              <button class="accordion-button p-0 border-0 fs-5 text-uppercase" type="button" data-bs-toggle="collapse" data-bs-target="#accordion-filter-2" aria-expanded="true" aria-controls="accordion-filter-2">
                Color
                <svg class="accordion-button__icon type2" viewBox="0 0 10 6" xmlns="http://www.w3.org/2000/svg">
                  <g aria-hidden="true" stroke="none" fill-rule="evenodd">
                    <path d="M5.35668 0.159286C5.16235 -0.053094 4.83769 -0.0530941 4.64287 0.159286L0.147611 5.05963C-0.0492049 5.27473 -0.049205 5.62357 0.147611 5.83813C0.344427 6.05323 0.664108 6.05323 0.860924 5.83813L5 1.32706L9.13858 5.83867C9.33589 6.05378 9.65507 6.05378 9.85239 5.83867C10.0492 5.62357 10.0492 5.27473 9.85239 5.06018L5.35668 0.159286Z"/>
                  </g>
                </svg>
              </button>
            </h5>
        
            <div id="accordion-filter-brand" class="accordion-collapse collapse show border-0" aria-labelledby="accordion-heading-brand" data-bs-parent="#brand-filters">
              <div class="search-field multi-select accordion-body px-0 pb-0">
                <select class="d-none" multiple name="total-numbers-list">
                  <option value="1">Red</option>
                  <option value="2">Greeen</option>
                  <option value="3">White</option>
                  <option value="4">Pink</option>
                  <option value="5">Yellow</option>
                  <option value="5">Black</option>
                  <option value="5">Blue</option>
                </select>
                <ul class="multi-select__list list-unstyled">
                  @foreach($colors as $color)
                      <a href="#" data-color = "{{ $color }}" class="search-suggestion__item multi-select__item text-primary js-search-select js-multi-select js-filter">
                        <span class="me-auto">{{ ucwords($color) ?? '' }}</span>
                      </a>
                  @endforeach
                </ul>
              </div>
            </div>
          </div><!-- /.accordion-item -->
        </div><!-- /.accordion -->


        <div class="accordion" id="size-filters">
          <div class="accordion-item mb-4 pb-3">
            <h5 class="accordion-header" id="accordion-heading-size">
              <button class="accordion-button p-0 border-0 fs-5 text-uppercase" type="button" data-bs-toggle="collapse" data-bs-target="#accordion-filter-size" aria-expanded="true" aria-controls="accordion-filter-size">
                Sizes
                <svg class="accordion-button__icon type2" viewBox="0 0 10 6" xmlns="http://www.w3.org/2000/svg">
                  <g aria-hidden="true" stroke="none" fill-rule="evenodd">
                    <path d="M5.35668 0.159286C5.16235 -0.053094 4.83769 -0.0530941 4.64287 0.159286L0.147611 5.05963C-0.0492049 5.27473 -0.049205 5.62357 0.147611 5.83813C0.344427 6.05323 0.664108 6.05323 0.860924 5.83813L5 1.32706L9.13858 5.83867C9.33589 6.05378 9.65507 6.05378 9.85239 5.83867C10.0492 5.62357 10.0492 5.27473 9.85239 5.06018L5.35668 0.159286Z"/>
                  </g>
                </svg>
              </button>
            </h5>
            <div id="accordion-filter-size" class="accordion-collapse collapse show border-0" aria-labelledby="accordion-heading-size" data-bs-parent="#size-filters">
              <div class="accordion-body px-0 pb-0">
                <div class="d-flex flex-wrap">
                  @foreach($sizes as $size)
                  <a href="#" data-size = "{{ $size }}" class="swatch-size btn btn-sm btn-outline-light mb-3 me-3 js-filter">{{ $size }}</a>
                  @endforeach
                </div>
              </div>
            </div>
          </div><!-- /.accordion-item -->
        </div>


        <div class="accordion" id="brand-filters">
          <div class="accordion-item mb-4 pb-3">
            <h5 class="accordion-header" id="accordion-heading-brand">
              <button class="accordion-button p-0 border-0 fs-5 text-uppercase" type="button" data-bs-toggle="collapse" data-bs-target="#accordion-filter-brand" aria-expanded="true" aria-controls="accordion-filter-brand">
                Brands
                <svg class="accordion-button__icon type2" viewBox="0 0 10 6" xmlns="http://www.w3.org/2000/svg">
                  <g aria-hidden="true" stroke="none" fill-rule="evenodd">
                    <path d="M5.35668 0.159286C5.16235 -0.053094 4.83769 -0.0530941 4.64287 0.159286L0.147611 5.05963C-0.0492049 5.27473 -0.049205 5.62357 0.147611 5.83813C0.344427 6.05323 0.664108 6.05323 0.860924 5.83813L5 1.32706L9.13858 5.83867C9.33589 6.05378 9.65507 6.05378 9.85239 5.83867C10.0492 5.62357 10.0492 5.27473 9.85239 5.06018L5.35668 0.159286Z"/>
                  </g>
                </svg>
              </button>
            </h5>
            <div id="accordion-filter-brand" class="accordion-collapse collapse show border-0" aria-labelledby="accordion-heading-brand" data-bs-parent="#brand-filters">
              <div class="search-field multi-select accordion-body px-0 pb-0">
                <select class="d-none" multiple name="total-numbers-list">
                  <option value="1">Adidas</option>
                  <option value="2">Balmain</option>
                  <option value="3">Balenciaga</option>
                  <option value="4">Burberry</option>
                  <option value="5">Kenzo</option>
                  <option value="5">Givenchy</option>
                  <option value="5">Zara</option>
                </select>
                <!-- <div class="search-field__input-wrapper mb-3">
                  <input type="text" name="search_text" class="search-field__input form-control form-control-sm border-light border-2" placeholder="SEARCH">
                </div> -->
                <ul class="multi-select__list list-unstyled">
                  @foreach($brands as $brand)
                      <a href="#" data-brand = "{{ $brand->id }}" class="search-suggestion__item multi-select__item text-primary js-search-select js-multi-select js-filter">
                        <span class="me-auto">{{ $brand->name ?? '' }}</span>
                      </a>
                  @endforeach
                </ul>
              </div>
            </div>
          </div><!-- /.accordion-item -->
        </div>


        <div class="accordion" id="price-filters">
          <div class="accordion-item mb-4">
            <h5 class="accordion-header mb-2" id="accordion-heading-price">
              <button class="accordion-button p-0 border-0 fs-5 text-uppercase" type="button" data-bs-toggle="collapse" data-bs-target="#accordion-filter-price" aria-expanded="true" aria-controls="accordion-filter-price">
                Price
                <svg class="accordion-button__icon type2" viewBox="0 0 10 6" xmlns="http://www.w3.org/2000/svg">
                  <g aria-hidden="true" stroke="none" fill-rule="evenodd">
                    <path d="M5.35668 0.159286C5.16235 -0.053094 4.83769 -0.0530941 4.64287 0.159286L0.147611 5.05963C-0.0492049 5.27473 -0.049205 5.62357 0.147611 5.83813C0.344427 6.05323 0.664108 6.05323 0.860924 5.83813L5 1.32706L9.13858 5.83867C9.33589 6.05378 9.65507 6.05378 9.85239 5.83867C10.0492 5.62357 10.0492 5.27473 9.85239 5.06018L5.35668 0.159286Z"/>
                  </g>
                </svg>
              </button>
            </h5>
            <div id="accordion-filter-price" class="accordion-collapse collapse show border-0" aria-labelledby="accordion-heading-price" data-bs-parent="#price-filters">
              <input class="price-range-slider" type="text" name="price_range" value="" data-slider-min="{{ $min_price ?? '' }}" data-slider-max="{{ $max_price ?? '' }}" data-slider-step="5" data-slider-value="[{{ $min_price ?? '' }},{{ $max_price ?? '' }}]" data-currency="Rs. ">
              <div class="price-range__info d-flex align-items-center mt-2">
                <div class="me-auto">
                  <span class="text-secondary">Min Price: </span>
                  <span class="price-range__min">Rs. {{ $min_price ?? '' }}</span>
                </div>
                <div>
                  <span class="text-secondary">Max Price: </span>
                  <span class="price-range__max">Rs. {{ $max_price ?? '' }}</span>
                </div>
              </div>
            </div>
          </div><!-- /.accordion-item -->
        </div>
      </div>

      <div class="shop-list flex-grow-1 mb-5">
        <div class="d-flex justify-content-between mb-4 pb-md-2">
          <!-- <div class="breadcrumb mb-0 d-none d-md-block flex-grow-1">
            <a href="#" class="menu-link menu-link_us-s text-uppercase fw-medium" >Home</a>
            <span class="breadcrumb-separator menu-link fw-medium ps-1 pe-1">/</span>
            
          </div> -->

          <div class="shop-acs d-flex align-items-center justify-content-between justify-content-md-end flex-grow-1">
            <select class="shop-acs__select form-select w-auto border-0 py-0 order-1 order-md-0 js-filter" aria-label="Sort Items" name="sort">
              <option value="">Default Sorting</option>
              <!-- <option value="1">Featured</option>
              <option value="2">Best selling</option>
              <option value="3">Alphabetically, A-Z</option>
              <option value="3">Alphabetically, Z-A</option> -->
              <option value="low_high">Price, low to high</option>
              <option value="high_low">Price, high to low</option>
              <option value="old_new">Date, old to new</option>
              <option value="new_old">Date, new to old</option>
            </select>

            <div class="shop-asc__seprator mx-3 bg-light d-none d-md-block order-md-0"></div>

            <div class="col-size align-items-center order-1 d-none d-lg-flex">
              <span class="text-uppercase fw-medium me-2">View</span>
              <button class="btn-link fw-medium me-2 js-cols-size" data-target="products-grid" data-cols="2">2</button>
              <button class="btn-link fw-medium me-2 js-cols-size" data-target="products-grid" data-cols="3">3</button>
              <button class="btn-link fw-medium js-cols-size" data-target="products-grid"  data-cols="4">4</button>
            </div><!-- /.col-size -->

            <div class="shop-filter d-flex align-items-center order-0 order-md-3 d-lg-none">
              <button class="btn-link btn-link_f d-flex align-items-center ps-0 js-open-aside" data-aside="shopFilter">
                <svg class="d-inline-block align-middle me-2" width="14" height="10" viewBox="0 0 14 10" fill="none" xmlns="http://www.w3.org/2000/svg"><use href="#icon_filter" /></svg>
              <span class="text-uppercase fw-medium d-inline-block align-middle">Filter</span>
              </button>
            </div>
          </div>
        </div>
        <div id = "data-load"> 
          <div class="products-grid row row-cols-2 row-cols-md-3" id="products-grid" >
            @if($product->isEmpty())
              <div class="product-card-wrapper trans">
                  <h3>No data found.</h3>
              </div>                                                                
                @else
                
                @foreach($product as $item)  
                <div class="product-card-wrapper trans">
                  <div class="product-card mb-3 mb-md-4 mb-xxl-5">
                    <div class="pc__img-wrapper">
                      <div class="swiper-container background-img js-swiper-slider" data-settings='{"resizeObserver": true}'>
                        <div class="swiper-wrapper">
                          @if(!empty($item->bulk_images) && is_array(json_decode($item->bulk_images, true)))
                            @foreach(json_decode($item->bulk_images, true) as $image)
                              <div class="swiper-slide">
                                <a href="{{ route('products', ['category' => $item->category->slug, 'product_id' => $item->product_id, 'sub_sku' => $item->sub_sku, 'slug' => $item->slug ?? '', 'size' => $item->size ?? '', 'color' => $item->color ?? '']) }}">
                                  <img loading="lazy" src="{{ asset('uploads/products/' . $image) }}" width="330" height="400" alt="{{ $item->name }}" class="pc__img">
                                </a>
                              </div>
                            @endforeach
                          
                          @else
                        <!-- Fallback: Featured Image -->
                        <div class="swiper-slide">
                            <a href="{{ route('products', ['category' => $item->category->slug, 'product_id' => $item->product_id, 'sub_sku' => $item->sub_sku, 'slug' => $item->slug ?? '', 'size' => $item->size ?? '', 'color' => $item->color ?? '']) }}">
                                <img loading="lazy" src="{{ asset('uploads/products/' . $item->featured_image) }}" width="330" height="400" alt="{{ $item->name ?? ''}}" class="pc__img">
                            </a>
                        </div>
                        @endif              
                      </div>
                        <span class="pc__img-prev"><svg width="7" height="11" viewBox="0 0 7 11" xmlns="http://www.w3.org/2000/svg"><use href="#icon_prev_sm" /></svg></span>
                        <span class="pc__img-next"><svg width="7" height="11" viewBox="0 0 7 11" xmlns="http://www.w3.org/2000/svg"><use href="#icon_next_sm" /></svg></span>
                      </div>
                      <!--<button class="pc__atc btn anim_appear-bottom btn position-absolute border-0 text-uppercase fw-medium js-add-cart js-open-aside" data-aside="cartDrawer" title="Add To Cart">Add To Cart</button>-->
                    </div>

                    <div class="pc__info position-relative">
                      <h6 class="pc__title"><a href="{{ route('products', ['category' => $item->category->slug, 'product_id' => $item->product_id, 'sub_sku' => $item->sub_sku, 'slug' => $item->slug ?? '', 'size' => $item->size ?? '', 'color' => $item->color ?? '']) }}">{{ $item->name ?? ''}}</a></h6>
                      <div class="product-card__price d-flex justify-content-center">
        
                        @if(isset($item->selling_price) && $item->selling_price != 0)
                        <span class="money price price-old">Rs. {{ $item->mrp ?? ''}}</span>
                        <span class="money price pr-color">Rs. {{ $item->selling_price ?? ''}}</span>
                        @else
                        <span class="money price">Rs. {{ $item->mrp ?? ''}}</span>
                        @endif
                      </div>              

                      <button class="pc__btn-wl position-absolute top-0 end-0 bg-transparent border-0 js-add-wishlist" title="Add To Wishlist">
                        <svg width="16" height="16" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg"><use href="#icon_heart" /></svg>
                      </button>
                    </div>
                  </div>
                </div>
          
                @endforeach
                
            @endif
          </div>
      </div>
    </div>
    </section>
     <div class="mb-3 mb-md-4 mb-xl-5 pb-2 pt-1"></div>
      <section class="grid-banner container mb-5" id="section-grid-banner">
      <div class="row justify-content-center">
        <div class="col-lg-2 col-6 grid-banner__itemss ">
          <div class="grid-banner__items  mb-3">
            <img src="{{ asset('assets/images/icons/14.png') }}" alt="Uomo" class="iconss d-block">
              <h3 class="iconss-text mb-1">100% Authentic Products</h3>
           
          </div>
        </div>
        <div class="col-lg-2 col-6 grid-banner__itemss">
          <div class="grid-banner__items  mb-3">
            <img src="{{ asset('assets/images/icons/13.png') }}" alt="Uomo" class="iconss d-block icons">
              <h3 class="iconss-text mb-1">Secure Payment</h3>
           
          </div>
        </div>
        <div class="col-lg-2 col-6 grid-banner__itemss">
          <div class="grid-banner__items  mb-3">
            <img src="{{ asset('assets/images/icons/12.png') }}" alt="Uomo" class="iconss d-block icons">
              <h3 class="iconss-text mb-1">Quality Checked</h3>
           
          </div>
        </div>
        <div class="col-lg-2 col-6">
          <div class="grid-banner__items  mb-3">
            <img src="{{ asset('assets/images/icons/11.png') }}" alt="Uomo" class="iconss d-block icons">
              <h3 class="iconss-text mb-1">7 Days Return</h3>
           
          </div>
        </div>
      </div><!-- /.row -->
    </section>
  </main>

@include('layouts.footer')
<script>
$(document).ready(function () {
    // let slug = "{{ $item->category->slug }}";

    function applyFilters() {
        // Gather selected values
        let selectedColors = [];
        let selectedSizes = [];
        let selectedBrands = [];

        $('.js-filter.active').each(function () {
            let color = $(this).data('color');
            let size = $(this).data('size');
            let brand = $(this).data('brand');

            if (color) selectedColors.push(color);
            if (size) selectedSizes.push(size);
            if (brand) selectedBrands.push(brand);
        });

        // Sort option
        let sort = $('select[name="sort"]').val();

        // Price range from slider
        let priceRange = $('.price-range-slider').val(); // "[100,500]"
        let minPrice = '', maxPrice = '';
        if (priceRange) {
            let parsed = priceRange.replace(/[\[\]]/g, '').split(',');
            minPrice = parsed[0];
            maxPrice = parsed[1];
        }

        // Build URL
        const urlParams = new URLSearchParams();
        if (selectedColors.length) urlParams.set('color', selectedColors.join(','));
        if (selectedSizes.length) urlParams.set('size', selectedSizes.join(','));
        if (selectedBrands.length) urlParams.set('brand', selectedBrands.join(','));
        if (sort) urlParams.set('sort', sort);
        if (minPrice && maxPrice) {
            urlParams.set('min_price', minPrice);
            urlParams.set('max_price', maxPrice);
        }
        urlParams.set('keyword', "{{ request('keyword') }}");
        const BASE_URL = "{{ env('APP_URL') }}";

        var url = `${BASE_URL}/search-products?${urlParams.toString()}`;
      
        // AJAX load
        $.ajax({
            url: url,
            type: 'GET',
            beforeSend: function () {
                $('#data-load').html(`
                    <div id="loading" class="text-center my-5">
                        <div class="spinner-border text-primary" role="status">
                            <span class="visually-hidden">Loading...</span>
                        </div>
                    </div>
                `);
            },
            success: function (res) {
                let html = $(res).find('#data-load').html();
                $('#data-load').html(html);
                window.history.pushState({}, '', url);
            },
            error: function () {
                alert('Failed to load filtered products.');
            }
        });
    }

    // Main filter click handler
    $('.js-filter').on('click', function (e) {
        e.preventDefault();
        $(this).toggleClass('active');
        applyFilters();
    });

    // Sort change handler
    $('select[name="sort"]').on('change', function () {
        applyFilters();
    });

    // Price range change handler on slide stop
    $('.price-range-slider').on('slideStop', function () {
        applyFilters();
    });
    
});
</script>
