@include('layouts.header')
<main>
<div class="mb-4 pb-4"></div>
<section class="login-register container mb-5">
<h2 class="d-none">Register</h2>
<ul class="nav nav-tabs mb-5" id="login_register" role="tablist">
<li class="nav-item" role="presentation">
<a class="nav-link nav-link_underscore" id="register-tab" data-bs-toggle="tab" href="#tab-item-register" role="tab" aria-controls="tab-item-register" aria-selected="false">Register</a>
</li>
</ul>
    <div class="tab-content pt-2" id="login_register_tab_content">
    
    <div class="register-form">
        @if(session('message'))
                  <div class="alert alert-success" style="padding-top: 10px; padding-bottom: 10px;">
                    {{ session('message') }}
                  </div>
            @endif
    <form action="{{ route('user.register.save') }}" method="POST" name="register-form" class="needs-validation" novalidate>
    @csrf
    <div class="form-floating mb-3">
        <input name="name" type="text" class="form-control form-control_gray" id="customerNameRegisterInput" placeholder="Username" value="{{ old('name') }}">
        <label for="customerNameRegisterInput">Name</label>
        @if($errors->has('name'))
            <p class="text-danger">{{ $errors->first('name') }}</p>
        @endif
    </div>
    <div class="pb-3"></div>
    
    <div class="form-floating mb-3">
        <input name="email" type="email" class="form-control form-control_gray" id="customerEmailRegisterInput" placeholder="Email address *" value="{{ old('email') }}">
        <label for="customerEmailRegisterInput">Email address *</label>
        @if($errors->has('email'))
            <p class="text-danger">{{ $errors->first('email') }}</p>
        @endif
    </div>
    <div class="form-floating mb-3">
        <input name="mobile" type="tel" class="form-control form-control_gray" placeholder="Mobile *" pattern="[0-9]{10}" maxlength="10" value="{{ old('mobile') }}">
        <label for="customerEmailRegisterInput">Mobile *</label>
        @if($errors->has('mobile'))
            <p class="text-danger">{{ $errors->first('mobile') }}</p>
        @endif
    </div>
    <div class="pb-3"></div>
    <div class="form-floating mb-3">
        <input name="password" type="password" class="form-control form-control_gray" id="customerPasswodRegisterInput" placeholder="Password *" autocomplete="off">
        <label for="customerPasswodRegisterInput">Password *</label>
        @if($errors->has('password'))
            <p class="text-danger">{{ $errors->first('password') }}</p>
        @endif
    </div>
    <div class="d-flex align-items-center mb-3 pb-2">
         <p class="m-0">Your personal data will be used to support your experience throughout this website, to manage access to your account, and for other purposes described in our privacy policy.</p>
    </div>
    <button class="btn btn-primary w-100 text-uppercase" type="submit">Register</button>
    <div class="customer-option mt-4 text-center">
            <span class="text-secondary">Go to login page..</span>
        <a href="{{ route('user.login') }}" class="btn-text js-show-register">Login</a>
        </div>
    </form>
    </div>
</div>
</section>
</main>
 
@include('layouts.footer')