@include('layouts.header')
<main>
    <div class="mb-4 pb-4"></div>
    <section class="my-account container">
      <h2 class="page-title">Orders</h2>
      <div class="row">
        <div class="col-lg-3">
          <ul class="account-nav">
            <li><a href="javascript:void(0);" class="menu-link menu-link_us-s">Dashboard</a></li>
            <li><a href="javascript:void(0);" class="menu-link menu-link_us-s">Orders</a></li>
            <li><a href="javascript:void(0);" class="menu-link menu-link_us-s">Addresses</a></li>
            <li><a href="javascript:void(0);" class="menu-link menu-link_us-s">Account Details</a></li>
            <li><a href="javascript:void(0);" class="menu-link menu-link_us-s menu-link_active">Wishlist</a></li>
          </ul>
        </div>
        <div class="col-lg-9">
          <div class="page-content my-account__orders-list">
            <table class="orders-table">
              <thead>
                <tr>
                  <th>Order</th>
                  <th>Date</th>
                  <th>Status</th>
                  <th>Total</th>
                  <th>Actions</th>
                </tr>
              </thead>
              <tbody>
              
              <!-- @forelse($orders as $order)
                  <tr>
                      <td>{{ $order->order_id }}</td>
                      <td>{{ \Carbon\Carbon::parse($order->created_at)->format('F j, Y') }}</td>
                      <td>{{ ucfirst($order->order_status ?? 'Pending') }}</td>
                      <td>
                          Rs. {{ number_format($order->total, 2) }}
                          for {{ $order->qty }} {{ Str::plural('item', $order->qty) }}
                      </td>
                      <td>
                          <a href="{{ route('order.details', $order->id) }}" class="btn btn-primary">VIEW</a>
                      </td>
                  </tr>
              @empty
                  <tr>
                      <td colspan="5" class="text-center">You have no orders yet.</td>
                  </tr>
              @endforelse -->
              <tbody id="order-list">
                  @include('partials.orders_rows', ['orders' => $orders])
              </tbody>
            </table>
          </div>
          @if ($orders->hasMorePages())
              <div class="text-center mt-3">
                  <button id="load-more" class="btn btn-outline-primary" data-next-page="{{ $orders->currentPage() + 1 }}">Load More</button>
              </div>
              @endif
        </div>
        
      </div>
    </section>
  </main>

  <div class="mb-5 pb-xl-5"></div>
@include('layouts.footer')

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
    $(document).on('click', '#load-more', function () {
        let button = $(this);
        let page = button.data('next-page');

        $.ajax({
            url: "{{ route('my.order') }}",
            type: "GET",
            data: { page: page },
            beforeSend: function () {
                button.text('Loading...');
            },
            success: function (data) {
                $('#order-list').append(data);
                let nextPage = page + 1;
                button.data('next-page', nextPage);

                // If response is empty (no more rows)
                if (data.trim() === '') {
                    button.remove();
                } else {
                    button.text('Load More');
                }
            },
            error: function () {
                alert('Could not load more orders.');
                button.text('Load More');
            }
        });
    });
</script>

