@include('layouts.header')
<main>
<div class="mb-4 pb-4"></div>
<section class="shop-checkout container mb-5">
    <h2 class="page-title text-center">Order Detail</h2>
    @if(isset($order))
<div class="container">
    <div class="row align-items-center ord-no">
        <div class="col-6">
        <h4>Order #{{ $order->order_id ?? '' }}</h4>
        <p>{{ $order->created_at->format('M j') ?? ''}}</p>
        </div>
        </div>
        <div class="row">
        <div class="col-lg-8 col-12">

        <div class="delivery-box mb-3">
            <div class="date-box">
                <h4>
                    Expected:
                    {{ $order->expected_date ? \Carbon\Carbon::parse($order->expected_date)->format('M j') : '' }}
                </h4>
            </div>
        <div class="row">
        <div class="col-10">
        <h6>Status: {{ $order->order_status ?? ''}}</h6>
        </div>
        <div class="col-2">
            Show Details<i class="fa-solid fa-angle-down"></i>
        </div>
        </div>
        </div>
        <div class="order-detail-box">
            <div class="row">
            <h5 class="mb-3">Order details</h5>
            <div class="col-6">
            <div class="detail-box">
            <p><b>Product Name</b></p>
            <p>{{ $order->product->name ?? '' }}</p>
            </div>
            <div class="detail-box">
            <p><b>Address</b></p>
            <p>{{ $order->billing->address ?? '' }}</p>
            </div>
            <div class="detail-box">
            <p><b>State</b></p>
            <p>{{ $order->billing->state ?? '' }}</p>
            </div>
            <div class="detail-box">
            <p><b>City</b></p>
            <p>{{ $order->billing->city ?? '' }}</p>
            </div>
            </div>
            <div class="col-6">
            <div class="detail-box">
            <p><b>Postcode</b></p>
            <p>{{ $order->billing->post_code ?? '' }}</p>
            </div>
            <div class="detail-box">
            <p><b>Phone</b></p>
            <p>{{ $order->billing->phone ?? '' }}</p>
            </div>
            <div class="detail-box">
            <p><b>Email</b></p>
            <p>{{ $order->billing->email ?? '' }}</p>
            </div>
            </div>
            @if($order->order_status == 'Pending')
            <div class="col-12 d-flex justify-content-center">
            <a href="" class="btn btn-light btn-light-color d-block">Cancel</a>
            </div>
            @endif
        </div>
        </div>
        </div>
        <div class="col-lg-4 col-12">
        <div class="pay-box">
        <div class="pro-box">
        <div class="pro-img-nam">
        <img loading="lazy" src="{{ asset('uploads/products/'. $order->product->featured_image) }}" width="50" height="50" alt="">
        <div>
        <h6>{{ $order->product->name ?? '' }}</h6>
        <p>Size: {{ $order->product->size ?? '' }}</p>
        </div>
        </div>
        </div>

        <div class="detail-box-contain">
        <h6>Mrp</h6>
        <p>Rs. {{ $order->mrp ?? ''}}</p>
        </div>

        <div class="detail-box-contain">
        <h6>qty</h6>
        <p>{{ $order->qty ?? '' }}</p>
        </div>

        <div class="detail-box-contain">
        <h6>Total Mrp</h6>
        <p>Rs. {{ $order->mrp*$order->qty ?? '' }}</p>
        </div>
        <div class="detail-box-contain">
        <h6>Coupon Discount</h6>
        <p>Rs. {{ $order->coupon_discount ?? ''}}</p>
        </div>
        </div>
        </div>
        </div>
    </div>
</div>
    @else
    <div class="container" style="padding-top: 130px; padding-bottom: 130px;">
        <h2 class="page-title text-center text-danger">Order Detail Not Found!</h2>   
    </div>   
    @endif
</section>
</main>

@include('layouts.footer')
