@include('admin.layouts.header')
@include('admin.layouts.sidebar') 

<link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css">                 
        <!-- Vertical Overlay-->
        <div class="vertical-overlay"></div>
        <div class="main-content">

            <div class="page-content">
                <div class="container-fluid">
                    <div class="row">
                        <div class="col-12">
                            <div class="page-title-box d-sm-flex align-items-center justify-content-between bg-galaxy-transparent">
                                <h4 class="mb-sm-0">Product List</h4>

                                <div class="page-title-right">
                                    <ol class="breadcrumb m-0">
                                        <li class="breadcrumb-item"><a href="javascript: void(0);">Tables</a></li>
                                        <li class="breadcrumb-item active">Product List</li>
                                    </ol>
                                </div>

                            </div>
                        </div>
                    </div>
                    <!-- end page title -->

                    <div class="row">
                    
                        <div class="col-xl-12">
                            <div class="card">
                                <div class="card-header align-items-center d-flex">
                                    <h4 class="card-title mb-0 flex-grow-1">Product List</h4>
                                    <div class="d-flex justify-content-end">
                                    <a href="{{ route('product.add') }}">
                                    <button type="button" class="btn btn-primary d-flex justify-content-end">Add Product</button>
                                    </a>
                                </div>
                                </div><!-- end card header -->

                                <div class="card-body">
                                    
                                    <div class="live-preview">
                                        <div class="table-responsive">
                                            <table id="example" class="table table-striped table-nowrap align-middle mb-0">
                                                <thead>
                                                    <tr>
                                                        <th scope="col">ID</th>
                                                        <th scope="col">Product Id</th>
                                                        <th scope="col">Product Name</th>
                                                        <th scope="col">Product Image</th>
                                                        <th scope="col">Product Price</th>
                                                        <th scope="col">Brand</th>
                                                        <th scope="col">Stock</th>
                                                        <th scope="col">Ctegories</th>
                                                        <th scope="col">Status</th>
                                                        <th scope="col">Product Variant</th>
                                                        <th scope="col">Action</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                @if($product == "" && $product->isEmpty())
                                                <tr>
                                                   <td colspan="5" class="text-center">No data found.</td>
                                                </tr>
                                                @else
                                                @foreach($product as $key => $item)
                                                    <tr>
                                                        <td class="fw-medium">{{ $key + 1 }}</td>
                                                        <td>{{ $item->product_id ?? ''}}</td>
                                                        <td>{{ $item->name ?? ''}}</td>
                                                        
                                                        <td>
                                                        @if($item->featured_image)
                                                        <img src="{{ asset('uploads/products/' . $item->featured_image) }}" alt="Product Image" width="50" height="50">
                                                        @else
                                                        <span class="text-muted">No Image</span>
                                                        @endif
                                                        </td>
                                                        <td>Mrp: {{ $item->mrp ?? ''}}/Selling Price: {{ $item->selling_price ?? ''}}/Discount: {{ $item->discount ?? ''}}</td>
                                                        <td>{{ $item->brand->name ?? '' }}</td>
                                                        <td>{{ $item->stock ?? ''}}</td>
                                                        <td>
                                                            {{ $item->category->name ?? '' }}
                                                            @if(!empty($item->category->name) && !empty($item->subCategory->name)) -> @endif
                                                            {{ $item->subCategory->name ?? '' }}
                                                            @if(!empty($item->subCategory->name) && !empty($item->childCategory->name)) -> @endif
                                                            {{ $item->childCategory->name ?? '' }}
                                                        </td>
                                                        <td><span class="badge bg-primary">{{ $item->status ?? ''}}</span></td>
                                                        <td><a href="{{ route('product.variant.add', $item->id) }}"><span class="badge bg-primary">Add Variant</span></a></td>
                                                        <td><div class="hstack gap-3 flex-wrap">
                                                            <a href="{{ route('product.edit', $item->id) }}" class="link-success fs-15"><i class="ri-edit-2-line"></i></a>
                                                            <a href="javascript:void(0);" 
                                                            class="link-danger fs-15 delete-category" 
                                                            data-id="{{ $item->id }}">
                                                            <i class="ri-delete-bin-line"></i>
                                                            </a>
                                                            <!-- <a href="{{ route('category.delete', $item->id) }}"  class="link-danger fs-15"><i class="ri-delete-bin-line"></i></a> -->
                                                        </div></td>
                                                    </tr>
                                                @endforeach    
                                                @endif       
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                    
                                </div><!-- end card-body -->
                            </div><!-- end card -->
                        </div>
                        <!-- end col -->
                    </div>
                </div>
            </div>
            <!-- End Page-content -->
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
document.addEventListener('DOMContentLoaded', function () {
    const deleteButtons = document.querySelectorAll('.delete-category');

    deleteButtons.forEach(button => {
        button.addEventListener('click', function () {
            const categoryId = this.getAttribute('data-id');
            Swal.fire({
                title: 'Are you sure?',
                text: "This action cannot be undone!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, delete it!'
            }).then((result) => {
                if (result.isConfirmed) {
                    let deleteUrl = "{{ route('product.delete', ':id') }}".replace(':id', categoryId);
                    window.location.href = deleteUrl;
                }
            });
        });
    });
});
</script>

@include('admin.layouts.footer')  
<!-- DataTables JS -->
    <script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>

    <script>
    $(document).ready(function () {
        $('#example').DataTable({
        responsive: true
        });
    });
    </script>


