@include('admin.layouts.header')
@include('admin.layouts.sidebar')
        <!-- ============================================================== -->
        <!-- Start right Content here -->
        <!-- ============================================================== -->
        <div class="main-content">

            <div class="page-content">
                <div class="container-fluid">

                    <!-- start page title -->
                    <div class="row">
                        <div class="col-12">
                            <div class="page-title-box d-sm-flex align-items-center justify-content-between bg-galaxy-transparent">
                                <h4 class="mb-sm-0">Edit Categories</h4>

                                <div class="page-title-right">
                                    <ol class="breadcrumb m-0">
                                        <li class="breadcrumb-item"><a href="javascript: void(0);">Forms</a></li>
                                        <li class="breadcrumb-item active">Edit Categories</li>
                                    </ol>
                                </div>

                            </div>
                        </div>
                    </div>
                    <!-- end page title -->

                    <div class="row">
                        <div class="col-lg-12">
                            <div class="card">
                                
                            <form action="{{ route('product.variant.type.update', $productVariant->id) }}" method="post">
                                @csrf
                                <div class="card-body">
                                    <div class="live-preview">
                                        <div class="row gy-4">
                                            <div class="col-xxl-6 col-md-6">
                                                <div>
                                                    <label for="basiInput" class="form-label">Variation Type</label>
                                                    <input type="text" name="variation_type" class="form-control" id="basiInput" placeholder="Enter Variation Type" value="{{ $productVariant->variation_type }}">
                                                    @if($errors->has('variation_type'))
                                                    <p class="text-danger">{{ $errors->first('variation_type') }}</p>
                                                    @endif
                                                </div>
                                            </div>
                                            <!--end col-->
                                            <div class="col-xxl-6 col-md-6">
                                                <div>
                                                    <label for="statusSelect" class="form-label">Status</label>
                                                    <select name="status" class="form-select" id="statusSelect">
                                                        <option value="">Select Status</option>
                                                        <option value="active" {{ old('status', $productVariant->status) == 'active' ? 'selected' : '' }}>Active</option>
                                                        <option value="inactive" {{ old('status', $productVariant->status) == 'inactive' ? 'selected' : '' }}>Inactive</option>
                                                    </select>
                                                    @if($errors->has('status'))
                                                    <p class="text-danger">{{ $errors->first('status') }}</p>
                                                    @endif    
                                                </div>
                                            </div>

                                            <!--end col-->
                                                <div style="text-align: center;">
                                                <button type="submit" class="btn btn-primary">Submit</button>
                                                </div>
                                            
                                            <!--end col-->
                                        </div>
                                        <!--end row-->
                                    </div>
                                
                                </div>
                            </form>
                            </div>
                        </div>
                        <!--end col-->
                    </div>
                    <!--end row-->


@include('admin.layouts.footer')                   