@include('admin.layouts.header')
@include('admin.layouts.sidebar')
<div class="main-content">

            <div class="page-content">
                <div class="container-fluid">
                    <div class="row">

                        <div class="col-xxl-12">
                            <h5 class="mb-3">Order List</h5>
                            <div class="card">
                                <div class="card-body">
                                    <!-- Nav tabs -->
                                    
                                    <ul class="nav nav-tabs nav-tabs-custom nav-success nav-justified mb-3" role="tablist">
                                        <li class="nav-item">
                                            <a class="nav-link active" data-status="Pending" href="javascript:void(0);">
                                                Pending
                                            </a>
                                        </li>
                                        <li class="nav-item">
                                            <a class="nav-link" data-status="Confirm" href="javascript:void(0);">
                                                Confirm
                                            </a>
                                        </li>
                                        <li class="nav-item">
                                            <a class="nav-link" data-status="Shipped" href="javascript:void(0);">
                                                Shipped
                                            </a>
                                        </li>
                                        <li class="nav-item">
                                            <a class="nav-link" data-status="Delivered" href="javascript:void(0);">
                                                Delivered
                                            </a>
                                        </li>
                                        <li class="nav-item">
                                            <a class="nav-link" data-status="Canceled" href="javascript:void(0);">
                                                Canceled
                                            </a>
                                        </li>
                                    </ul>

                                    <!-- Tab panes -->
                                    
                                    <div class="tab-content text-muted">

                                        <div class="tab-pane active" id="tab" role="tabpanel">
                                        
                                            <div class="live-preview">
                                                <div class="table-responsive">
                                                    <table id="example" class="table table-striped table-nowrap align-middle mb-0">
                                                        <thead>
                                                            <tr>
                                                                <th scope="col">Sr. No</th>
                                                                <th scope="col">Order Id</th>
                                                                <th scope="col">Date</th>
                                                                <th scope="col">Total</th>
                                                                <th scope="col">Status</th>
                                                                <th scope="col">Expected Date</th>
                                                                <th scope="col">Action</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody id="order-table-body">

                                                        <!-- Edit Status Modal -->
                                                        <div class="modal fade" id="editStatusModal" tabindex="-1" aria-labelledby="editStatusLabel" aria-hidden="true">
                                                        <div class="modal-dialog">
                                                            <form id="updateStatusForm">
                                                            @csrf
                                                            <input type="hidden" name="order_id" id="modal-order-id">
                                                            <div class="modal-content">
                                                                <div class="modal-header">
                                                                <h5 class="modal-title" id="editStatusLabel">Update Order Status</h5>
                                                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                                </div>

                                                                <div class="modal-body">
                                                                <div class="mb-3">
                                                                    <label for="order-status" class="form-label">Select Status</label>
                                                                    <select class="form-select" name="order_status" id="order-status" required>
                                                                    <option value="Pending">Pending</option>
                                                                    <option value="Confirm">Confirm</option>
                                                                    <option value="Shipped">Shipped</option>
                                                                    <option value="Delivered">Delivered</option>
                                                                    <option value="Canceled">Canceled</option>
                                                                    </select>
                                                                </div>
                                                                <div class="mb-3">
                                                                    <label for="expected-date" class="form-label">Expected Delivery Date</label>
                                                                    <input type="date" name="expected_date" id="expected-date" class="form-control" required value="">
                                                                </div>
   
                                                                </div>

                                                                <div class="modal-footer">
                                                                <button type="submit" class="btn btn-success">Update</button>
                                                                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                                                                </div>

                                                            </div>
                                                            </form>
                                                        </div>
                                                        </div>

                                 
                                                        </tbody>
                                                    </table>
                                                    <div id="pagination-links" class="mt-3" style="float:right"></div>      
                                                </div>
                                            </div>
                                        </div>                                        
                                        
                                    </div>
                                </div><!-- end card-body -->
                            </div><!-- end card -->
                        </div>
                        <!--end col-->
                    </div>
                    <!--end row-->                

                </div>
                <!-- container-fluid -->
            </div>
            <!-- End Page-content -->
        </div>
        <!-- end main content-->
    
@include('admin.layouts.footer')
<script>
    let currentStatus = "Pending"; // Global scope

    // ✅ Move loadOrders to global scope
    function loadOrders(status = currentStatus, page = 1) {
        currentStatus = status;

        $.ajax({
            url: "{{ route('orders.by.status') }}",
            type: "GET",
            data: { status: status, page: page },
            success: function (response) {
                let rows = "";

                if (response.orders.length === 0) {
                    rows = `<tr><td colspan="6" class="text-center">No Orders Found</td></tr>`;
                } else {
                    $.each(response.orders, function (index, order) {
                        rows += `
                            <tr>
                                <td>${order.sr_no}</td>
                                <td>${order.order_id}</td>
                                <td>${order.date}</td>
                                <td>${order.total}</td>
                                <td>${order.status}</td>
                                <td>${order.expected_date}</td>
                                <td>${order.action}</td>
                            </tr>
                        `;
                    });
                }

                $("#order-table-body").html(rows);
                $("#pagination-links").html(response.pagination);
            }
        });
    }

    $(document).ready(function () {
        // On tab click
        $('.nav-link').click(function () {
            $('.nav-link').removeClass('active');
            $(this).addClass('active');
            let status = $(this).data('status');
            loadOrders(status);
        });

        // On pagination click
        $(document).on('click', '.pagination a', function (e) {
            e.preventDefault();
            let page = $(this).attr('href').split('page=')[1];
            loadOrders(currentStatus, page);
        });

        // Initial load
        loadOrders();
    });

    // Show modal
    $(document).on('click', '.edit-status', function () {
        let orderId = $(this).data('id');
        let status = $(this).data('status');
        let expectedDate = $(this).data('expected-date');

        $('#modal-order-id').val(orderId);
        $('#order-status').val(status);

        if (expectedDate) {
        $('#expected-date').val(expectedDate);
        } else {
            $('#expected-date').val('');
        }
        
        $('#editStatusModal').modal('show');
    });

    // Submit updated status
    $('#updateStatusForm').submit(function (e) {
        e.preventDefault();
        let formData = $(this).serialize();

        $.ajax({
            url: "{{ route('orders.update.status') }}",
            type: "POST",
            data: formData,
            success: function (response) {
                $('#editStatusModal').modal('hide');

                let activeStatus = $('.nav-link.active').data('status');
                console.log(activeStatus);                
                loadOrders(activeStatus); // ✅ now accessible
            },
            error: function () {
                alert('Failed to update status.');
            }
        });
    });
</script>



