@include('admin.layouts.header')
@include('admin.layouts.sidebar')

<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/nestable2@1.6.0/jquery.nestable.min.css" />
        <!-- ============================================================== -->
        <!-- Start right Content here -->
        <!-- ============================================================== -->
        <div class="main-content">

            <div class="page-content">
                <div class="container-fluid">

                    <!-- start page title -->
                    <div class="row">
                        <div class="col-12">
                            <div class="page-title-box d-sm-flex align-items-center justify-content-between bg-galaxy-transparent">
                                <h4 class="mb-sm-0">Add Menu Order</h4>

                                <div class="page-title-right">
                                    <ol class="breadcrumb m-0">
                                        <li class="breadcrumb-item"><a href="javascript: void(0);">Forms</a></li>
                                        <li class="breadcrumb-item active">Add Menu Order</li>
                                    </ol>
                                </div>

                            </div>
                        </div>
                    </div>
                    <!-- end page title -->

                    <div class="row">
                        <div class="col-lg-12">
                            <div class="card success-message">
                                                            
                                <div class="card-body">
                                    <div class="live-preview">
                                        <div class="row gy-4">
                                            
                                            <!--end col-->
                                            <div class="col-xxl-6 col-md-6">
                                                <div class="menu-builder-container">
                                                    <div>
                                                        <h2 class="menu-title">Change Menu Order</h2>
                                                            <div class="dd" id="menu-nestable">
                                                                <ol class="dd-list">
                                                                    @foreach($menus as $menu)
                                                                        <li class="dd-item" data-id="{{ $menu->id }}">
                                                                            <div class="dd-handle">{{ $menu->name }}</div>

                                                                            @if($menu->children->count())
                                                                                <ol class="dd-list">
                                                                                    @foreach($menu->children as $child)
                                                                                        <li class="dd-item" data-id="{{ $child->id }}">
                                                                                            <div class="dd-handle">{{ $child->name }}</div>
                                                                                        </li>
                                                                                    @endforeach
                                                                                </ol>
                                                                            @endif
                                                                        </li>
                                                                    @endforeach
                                                                </ol>
                                                            </div>
                                                    </div>
                                                </div>
                                            </div>
                                        
                                            
                                        </div>
                                        <!--end row-->
                                    </div>
                                
                                </div>
                       
                            </div>
                        </div>
                        <!--end col-->
                    </div>
                    <!--end row-->


@include('admin.layouts.footer')

<!-- Nestable2 JS -->
<script src="https://cdn.jsdelivr.net/npm/nestable2@1.6.0/jquery.nestable.min.js"></script>

<script>
    $(document).ready(function () {
        $('#menu-nestable').nestable();
        $('#menu-nestable').on('change', function () {
            let data = $('#menu-nestable').nestable('serialize');

            $.ajax({
                url: '{{ route("menu.update.order") }}',
                type: 'POST',
                contentType: 'application/json',
                headers: {
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                },
                data: JSON.stringify({ data: data }),
                success: function (response) {
                    console.log('Order updated:', response);
                    // Optionally show a toast/alert
                    $('.success-message').prepend(`
                    <div class="w-50">
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        Menu order updated successfully.
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                    </div>
                `);
                },
                error: function (xhr) {
                    console.error('Error:', xhr.responseText);
                }
            });
        });
    });
</script>