@include('admin.layouts.header')
@include('admin.layouts.sidebar') 

<link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css">                 
        <!-- Vertical Overlay-->
        <div class="vertical-overlay"></div>
        <div class="main-content">

            <div class="page-content">
                <div class="container-fluid">
                    <div class="row">
                        <div class="col-12">
                            <div class="page-title-box d-sm-flex align-items-center justify-content-between bg-galaxy-transparent">
                                <h4 class="mb-sm-0">Coupon Code List</h4>

                                <div class="page-title-right">
                                    <ol class="breadcrumb m-0">
                                        <li class="breadcrumb-item"><a href="javascript: void(0);">Tables</a></li>
                                        <li class="breadcrumb-item active">Coupon Code List</li>
                                    </ol>
                                </div>

                            </div>
                        </div>
                    </div>
                    <!-- end page title -->

                    <div class="row">
                    
                        <div class="col-xl-12">
                            <div class="card">
                                <div class="card-header align-items-center d-flex">
                                    <h4 class="card-title mb-0 flex-grow-1">Coupon Code List</h4>
                                    <div class="d-flex justify-content-end">
                                    <a href="{{ route('coupon.code.add') }}">
                                    <button type="button" class="btn btn-primary d-flex justify-content-end">Add Coupon Code</button>
                                    </a>
                                </div>
                                </div><!-- end card header -->

                                <div class="card-body">
                                    
                                    <div class="live-preview">
                                        <div class="table-responsive">
                                            <table id="example" class="table table-striped table-nowrap align-middle mb-0">
                                                <thead>
                                                    <tr>
                                                        <th scope="col">ID</th>
                                                        <th scope="col">Coupon Code</th>
                                                        <th scope="col">Max Discount</th>
                                                        <th scope="col">Max Discount Value</th>
                                                        <th scope="col">Min Card Value</th>
                                                        <th scope="col">Applicable On</th>
                                                        <th scope="col">Applicable Times</th>
                                                        <th scope="col">Expiry Date</th>
                                                        <th scope="col">Action</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                @if($coupon_code == "" && $coupon_code->isEmpty())
                                                <tr>
                                                   <td colspan="5" class="text-center">No data found.</td>
                                                </tr>
                                                @else
                                                @foreach($coupon_code as $key => $item)
                                                    <tr>
                                                        <td class="fw-medium">{{ $key + 1 }}</td>
                                                        <td>{{ $item->coupon_code }}</td>
                                                        <td>{{ $item->max_discount }}</td>
                                                        <td>{{ $item->max_discount_value }}</td>
                                                        <td>{{ $item->min_card_value }}</td>
                                                        <td>{{ $item->applicable_on }}</td>
                                                        <td>{{ $item->applicable_times }}</td>
                                                        <td>{{ $item->expiry_date }}</td>
                                                        <td><div class="hstack gap-3 flex-wrap">
                                                             <a href="{{ route('coupon.code.edit', $item->id) }}" class="link-success fs-15"><i class="ri-edit-2-line"></i></a> 
                                                            <a href="javascript:void(0);" 
                                                            class="link-danger fs-15 delete-category" 
                                                            data-id="{{ $item->id }}">
                                                            <i class="ri-delete-bin-line"></i>
                                                            </a>
                                                        </div></td>
                                                    </tr>
                                                @endforeach    
                                                @endif       
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                    
                                </div><!-- end card-body -->
                            </div><!-- end card -->
                        </div>
                        <!-- end col -->
                    </div>
                </div>
            </div>
            <!-- End Page-content -->
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
document.addEventListener('DOMContentLoaded', function () {
    const deleteButtons = document.querySelectorAll('.delete-category');

    deleteButtons.forEach(button => {
        button.addEventListener('click', function () {
            const categoryId = this.getAttribute('data-id');
            Swal.fire({
                title: 'Are you sure?',
                text: "Deleting this subcategor will also delete all its childcategories",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, delete it!'
            }).then((result) => {
                if (result.isConfirmed) {
                    let deleteUrl = "{{ route('coupon.code.delete', ':id') }}".replace(':id', categoryId);
                    window.location.href = deleteUrl;
                }
            });
        });
    });
});
</script>

@include('admin.layouts.footer')  

<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
<script>
    $(document).ready(function () {
        $('#example').DataTable({
        responsive: true
        });
    });
</script>
