@include('admin.layouts.header')
@include('admin.layouts.sidebar')
        <!-- ============================================================== -->
        <!-- Start right Content here -->
        <!-- ============================================================== -->
        <div class="main-content">

            <div class="page-content">
                <div class="container-fluid">

                    <!-- start page title -->
                    <div class="row">
                        <div class="col-12">
                            <div class="page-title-box d-sm-flex align-items-center justify-content-between bg-galaxy-transparent">
                                <h4 class="mb-sm-0">Edit Categories</h4>

                                <div class="page-title-right">
                                    <ol class="breadcrumb m-0">
                                        <li class="breadcrumb-item"><a href="javascript: void(0);">Forms</a></li>
                                        <li class="breadcrumb-item active">Edit Categories</li>
                                    </ol>
                                </div>

                            </div>
                        </div>
                    </div>
                    <!-- end page title -->

                    <div class="row">
                        <div class="col-lg-12">
                            <div class="card">
                                
                            <form action="{{ route('child.category.update', $child_category->id) }}" method="post" enctype="multipart/form-data">
                                @csrf
                                <div class="card-body">
                                    <div class="live-preview">
                                        <div class="row gy-4">
                                            <div class="col-xxl-6 col-md-6">
                                                <div>
                                                    <label for="basiInput" class="form-label">Child Category Name</label>
                                                    <input type="text" name="name" class="form-control" id="basiInput" placeholder="Enter Child Category Name" value="{{ $child_category->name }}">
                                                    @if($errors->has('name'))
                                                    <p class="text-danger">{{ $errors->first('name') }}</p>
                                                    @endif
                                                </div>
                                            </div>
                                            <!--end col-->
                                            <div class="col-xxl-6 col-md-6">
                                                <div>
                                                    <label for="categorySelect" class="form-label">Sub Category</label>
                                                    <select name="sub_category_id" class="form-select" id="subCategorySelect">
                                                        <option value="">Select Category</option>
                                                        @foreach($sub_categories as $sub_category)
                                                            <option value="{{ $sub_category->id }}" {{ old('sub_category_id', $child_category->sub_category_id ?? '') == $sub_category->id ? 'selected' : '' }}>{{ $sub_category->name }}</option>
                                                        @endforeach
                                                    </select>
                                                    @if($errors->has('sub_category_id'))
                                                    <p class="text-danger">{{ $errors->first('sub_category_id') }}</p>
                                                    @endif    
                                                </div>
                                            </div>

                                            <div class="col-xxl-6 col-md-6">
                                                <div>
                                                    <label for="statusSelect" class="form-label">Status</label>
                                                    <select name="status" class="form-select" id="statusSelect">
                                                        <option value="">Select Status</option>
                                                        <option value="active" {{ old('status', $sub_category->status) == 'active' ? 'selected' : '' }}>Active</option>
                                                        <option value="inactive" {{ old('status', $sub_category->status) == 'inactive' ? 'selected' : '' }}>Inactive</option>
                                                    </select>
                                                    @if($errors->has('status'))
                                                    <p class="text-danger">{{ $errors->first('status') }}</p>
                                                    @endif    
                                                </div>
                                            </div>
                                            <div class="col-xxl-6 col-md-6">
                                                    <div>
                                                        <label for="image" class="form-label">Image</label>
                                                        <input type="file" name="image" class="form-control" id="image" >
                                                        @if($errors->has('image'))
                                                        <p class="text-danger">{{ $errors->first('image') }}</p>
                                                        @endif
                                                    </div>
                                                    @if($child_category->image)
                                                    <div class="mt-2">
                                                        <img src="{{ asset('uploads/child-categories/' . $child_category->image) }}" 
                                                            alt="Current Image" width="50">
                                                    </div>
                                                    @endif
                                                </div>

                                            <h4>SEO Terms</h4>
                                                <div class="col-xxl-6 col-md-6">
                                                    <div>
                                                        <label for="meta_title" class="form-label">Meta Title</label>
                                                        <div class="form-icon">
                                                            <input type="text" name="meta_title" class="form-control" id="weight" placeholder="Meta Title" value="{{ $child_category->meta_title }}">
                                                            @if($errors->has('meta_title'))
                                                            <p class="text-danger">{{ $errors->first('meta_title') }}</p>
                                                            @endif
                                                        </div>
                                                    </div>
                                                </div>

                                                <div class="col-xxl-6 col-md-6">
                                                    <div>
                                                        <label for="meta_description" class="form-label">Meta Description</label>
                                                        <textarea name="meta_description" class="form-control" id="meta_description" placeholder="Meta Description">{{ $child_category->meta_description }}</textarea>
                                                    </div>
                                                </div>

                                                <div class="col-xxl-6 col-md-6">
                                                    <div>
                                                        <label for="meta_keywords" class="form-label">Meta Keywords</label>
                                                        <textarea name="meta_keywords" class="form-control" id="meta_keywords" placeholder="Meta Keywords">{{ $child_category->meta_keywords }}</textarea>
                                                    </div>
                                                </div>

                                            <!--end col-->
                                                <div style="text-align: center;">
                                                <button type="submit" class="btn btn-primary">Submit</button>
                                                </div>
                                            
                                            <!--end col-->
                                        </div>
                                        <!--end row-->
                                    </div>
                                
                                </div>
                            </form>
                            </div>
                        </div>
                        <!--end col-->
                    </div>
                    <!--end row-->


@include('admin.layouts.footer')                   