@include('admin.layouts.header')
@include('admin.layouts.sidebar')
        <!-- ============================================================== -->
        <!-- Start right Content here -->
        <!-- ============================================================== -->
        <div class="main-content">

            <div class="page-content">
                <div class="container-fluid">

                    <!-- start page title -->
                    <div class="row">
                        <div class="col-12">
                            <div class="page-title-box d-sm-flex align-items-center justify-content-between bg-galaxy-transparent">
                                <h4 class="mb-sm-0">Add Categories</h4>

                                <div class="page-title-right">
                                    <ol class="breadcrumb m-0">
                                        <li class="breadcrumb-item"><a href="javascript: void(0);">Forms</a></li>
                                        <li class="breadcrumb-item active">Add Categories</li>
                                    </ol>
                                </div>

                            </div>
                        </div>
                    </div>
                    <!-- end page title -->

                    <div class="row">
                        <div class="col-lg-12">
                            <div class="card">
                                
                            <form action="{{ route('category.save') }}" method="post" enctype="multipart/form-data">
                                @csrf
                                <div class="card-body">
                                    <div class="live-preview">
                                        <div class="row gy-4">
                                            <div class="col-xxl-6 col-md-6">
                                                <div>
                                                    <label for="basiInput" class="form-label">Category Name</label>
                                                    <input type="text" name="name" class="form-control" id="basiInput" placeholder="Enter Category Name" value="{{ old('name') }}">
                                                    @if($errors->has('name'))
                                                    <p class="text-danger">{{ $errors->first('name') }}</p>
                                                    @endif
                                                </div>
                                            </div>
                                            <!--end col-->
                                            <div class="col-xxl-6 col-md-6">
                                                <div>
                                                    <label for="statusSelect" class="form-label">Status</label>
                                                    <select name="status" class="form-select" id="statusSelect">
                                                        <option value="">Select Status</option>
                                                        <option value="active">Active</option>
                                                        <option value="inactive">Inactive</option>
                                                    </select>
                                                    @if($errors->has('status'))
                                                    <p class="text-danger">{{ $errors->first('status') }}</p>
                                                    @endif    
                                                </div>
                                            </div>

                                               <div class="col-xxl-6 col-md-6">
                                                    <div>
                                                        <label for="featured_image" class="form-label">Image</label>
                                                        <input type="file" name="image" class="form-control" id="image" value="{{ old('image') }}">
                                                        @if($errors->has('image'))
                                                            <p class="text-danger">{{ $errors->first('image') }}</p>
                                                        @endif  
                                                    </div>
                                                </div>

                                                <h4>SEO Terms</h4>
                                                <div class="col-xxl-6 col-md-6">
                                                    <div>
                                                        <label for="meta_title" class="form-label">Meta Title</label>
                                                        <div>
                                                            <input type="text" name="meta_title" class="form-control" id="weight" placeholder="Meta Title" value="{{ old('meta_title') }}">
                                                            @if($errors->has('meta_title'))
                                                            <p class="text-danger">{{ $errors->first('meta_title') }}</p>
                                                            @endif
                                                        </div>
                                                    </div>
                                                </div>

                                                <div class="col-xxl-6 col-md-6">
                                                    <div>
                                                        <label for="meta_description" class="form-label">Meta Description</label>
                                                        <textarea name="meta_description" class="form-control" id="meta_description" placeholder="Meta Description">{{ old('meta_description') }}</textarea>
                                                    </div>
                                                </div>

                                                <div class="col-xxl-6 col-md-6">
                                                    <div>
                                                        <label for="meta_keywords" class="form-label">Meta Keywords</label>
                                                        <textarea name="meta_keywords" class="form-control" id="meta_keywords" placeholder="Meta Keywords">{{ old('meta_keywords') }}</textarea>
                                                    </div>
                                                </div>

                                            <!--end col-->
                                                <div style="text-align: center;">
                                                <button type="submit" class="btn btn-primary">Submit</button>
                                                </div>
                                            
                                            <!--end col-->
                                        </div>
                                        <!--end row-->
                                    </div>
                                
                                </div>
                            </form>
                            </div>
                        </div>
                        <!--end col-->
                    </div>
                    <!--end row-->


@include('admin.layouts.footer')                   