@include('admin.layouts.header')
@include('admin.layouts.sidebar')
        <!-- ============================================================== -->
        <!-- Start right Content here -->
        <!-- ============================================================== -->
        <div class="main-content">

            <div class="page-content">
                <div class="container-fluid">

                    <!-- start page title -->
                    <div class="row">
                        <div class="col-12">
                            <div class="page-title-box d-sm-flex align-items-center justify-content-between bg-galaxy-transparent">
                                <h4 class="mb-sm-0">Edit Brands</h4>

                                <div class="page-title-right">
                                    <ol class="breadcrumb m-0">
                                        <li class="breadcrumb-item"><a href="javascript: void(0);">Forms</a></li>
                                        <li class="breadcrumb-item active">Edit Brands</li>
                                    </ol>
                                </div>

                            </div>
                        </div>
                    </div>
                    <!-- end page title -->

                    <div class="row">
                        <div class="col-lg-12">
                            <div class="card">
                                
                            <form action="{{ route('brand.update', $brand->id) }}" method="post" enctype="multipart/form-data">
                                @csrf
                                <div class="card-body">
                                    <div class="live-preview">
                                        <div class="row gy-4">
                                            <div class="col-xxl-6 col-md-6">
                                                <div>
                                                    <label for="basiInput" class="form-label">Brand Name</label>
                                                    <input type="text" name="name" class="form-control" id="basiInput" placeholder="Enter Brand Name" value="{{ $brand->name }}">
                                                    @if($errors->has('name'))
                                                    <p class="text-danger">{{ $errors->first('name') }}</p>
                                                    @endif
                                                </div>
                                            </div>

                                            <div class="col-xxl-6 col-md-6">
                                                <div>
                                                    <label for="statusSelect" class="form-label">Status</label>
                                                    <select name="status" class="form-select" id="statusSelect">
                                                        <option value="">Select Status</option>
                                                        <option value="active" {{ old('status', $brand->status) == 'active' ? 'selected' : '' }}>Active</option>
                                                        <option value="inactive" {{ old('status', $brand->status) == 'inactive' ? 'selected' : '' }}>Inactive</option>
                                                    </select>
                                                    @if($errors->has('status'))
                                                    <p class="text-danger">{{ $errors->first('status') }}</p>
                                                    @endif    
                                                </div>
                                            </div>

                                            <div class="col-xxl-6 col-md-6">
                                                <div>
                                                    <label for="basiInput" class="form-label">Logo</label>
                                                    <input type="file" name="logo" class="form-control" id="basiInput" placeholder="Enter Brand Name" value="{{ old('logo') }}">
                                                    @if($errors->has('logo'))
                                                    <p class="text-danger">{{ $errors->first('logo') }}</p>
                                                    @endif
                                                </div>
                                                @if($brand->logo)
                                            <div class="mt-2">
                                                <img src="{{ asset('uploads/brands/' . $brand->logo) }}" 
                                                    alt="Current Image" width="100">
                                            </div>
                                            @endif
                                            </div>
                                            
                                            <!--end col-->
                                               
                                            <div class="col-xxl-6 col-md-6">
                                                <div>
                                                    <label for="basiInput" class="form-label">Description</label>
                                                    <textarea rows="6" type="text" name="description" class="form-control" id="basiInput" placeholder="Enter Description" >{{ $brand->description }}</textarea>
                                                    @if($errors->has('description'))
                                                    <p class="text-danger">{{ $errors->first('description') }}</p>
                                                    @endif
                                                </div>
                                            </div>

                                            <!--end col-->
                                                <div style="text-align: center;">
                                                <button type="submit" class="btn btn-primary">Submit</button>
                                                </div>
                                            
                                            <!--end col-->
                                        </div>
                                        <!--end row-->
                                    </div>
                                
                                </div>
                            </form>
                            </div>
                        </div>
                        <!--end col-->
                    </div>
                    <!--end row-->


@include('admin.layouts.footer')                   