@include('layouts.header')
  <main>
     <section class="full-width_padding mb-5">
      <div class="full-width_border border-2" style="border-color: #f5e6e0;">
        <div class="shop-banner position-relative ">
          <div class="background-img" style="background-color: #f5e6e0;">
            <img loading="lazy" src="images/shop/shop_banner_2.png" width="1759" height="420" alt="Pattern" class="slideshow-bg__img object-fit-cover">
          </div>

          <div class="shop-banner__content container position-absolute start-50 top-50 translate-middle">
            <h2 class="h1 text-uppercase text-center fw-bold mb-xl-4 mb-xl-5">About Us</h2>
           
          </div>
        </div>
      </div>
    </section>
    <section class="about-us container">
      <div class="">
        <h2 class="page-title">ABOUT Griffin Haute</h2>
      </div>
      <div class="about-us__content pb-5 mb-5">
        <div class=" d-lg-flex align-items-lg-center mb-5">
          <div class="image-wrapper col-lg-5">
            <!--<img class="h-auto" loading="lazy" src="images/about/about-2.jpg" width="450" height="500" alt="">-->
             <img class="h-auto" loading="lazy" src="images/product/b.png" width="450" height="500" alt="" style="border: 1px solid #ccc;">
          </div>
          <div class="content-wrapper col-lg-7 px-lg-4">
            <h5 class="mb-3">The Company</h5>
            <p>In an era dominated by fleeting trends and mass production, Grinffin Haute stands as a tribute to timeless craftsmanship. We believe clothing should be more than disposable—it should tell a story, celebrate artistry, and endure. Every Grinffin Haute garment is thoughtfully designed and meticulously constructed, blending heritage techniques with modern elegance. Our mission is to revive the soul of fashion by creating pieces that are as enduring in quality as they are in style.</p>
            <p>In a world saturated with fast fashion and fleeting trends, Grinffin Haute reclaims the art of true craftsmanship. Born out of a desire to slow fashion down, we are committed to creating garments that not only endure in quality but also resonate with purpose. At Grinffin Haute, every piece is a labor of love—meticulously crafted by skilled artisans who honor traditional techniques while embracing thoughtful innovation. Our collections are designed for those who appreciate subtle luxury, timeless silhouettes, and a deeper connection to what they wear. We source premium materials with integrity, 
            prioritizing sustainability and ethical practices at every step. More than just fashion, Grinffin Haute offers a return to intention—a celebration of clothing as an expression of identity, longevity, and artistry.</p>
          </div>
        </div>
        <div class="">
          <h3 class="mb-4">OUR STORY</h3>
          <p class="fs-6 fw-medium mb-4">Grinffin Haute began with a simple yet powerful belief: fashion should be meaningful, not momentary. Founded by visionaries who grew disillusioned with the waste and soulless pace of fast fashion, Grinffin Haute was born as an ode to enduring elegance and intentional design. Drawing inspiration from the precision of heritage tailoring and the quiet strength of minimalist beauty, we set out to create garments that honor both the maker and the wearer. From the first sketch to the final stitch, our story is woven with care, craftsmanship, and a deep respect for tradition. Grinffin Haute is not just a brand—it is a movement to restore depth, dignity, and timelessness to the way we dress.</p>
          <p class="mb-4">Grinffin Haute was born from a deep desire to restore meaning to the way we dress. In a time when fashion has become increasingly disposable and driven by trends, our founders envisioned something different—a return to craftsmanship, purpose, and artistry. The name Grinffin, inspired by the mythological creature symbolizing strength and guardianship, reflects our commitment to protecting the values of timeless design and ethical creation. Haute, meaning “high” in French, honors the elevated standards and meticulous detail that define every piece we make.</p>
          <p>Our journey began in small ateliers, surrounded by fabric swatches, vintage tailoring manuals, and artisans who still believed in the beauty of slow fashion. We set out not to chase seasons, but to create garments that tell a story—of where they came from, who made them, and why they matter. Each collection is shaped by a reverence for the past and a responsibility for the future. We use only the finest materials, sourced responsibly, and work with skilled craftspeople who bring decades of expertise to every stitch.</p>
          <p>Grinffin Haute is more than a label—it’s a philosophy. We believe clothing should be lived in, not discarded; that fashion should express identity, not just image. As we continue to grow, our story remains grounded in the same values that sparked our beginning: intentionality, longevity, and a quiet defiance of the fast-paced fashion cycle.</p>
          <div class="row mb-3">
            <div class="col-md-6">
              <h5 class="mb-3">Our Mission</h5>
              <p class="mb-3">Quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.</p>
            </div>
            <div class="col-md-6">
              <h5 class="mb-3">Our Vision</h5>
              <p class="mb-3">Quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.</p>
            </div>
          </div>
        </div>
       
         <p class="">
          <img loading="lazy" class="w-100 h-auto d-block" src="images/about/about-1.jpg" width="1410" height="550" alt="">
        </p>
      </div>
    </section>
    <section class="service-promotion horizontal container mw-930 pt-0 mb-md-4 pb-md-4 mb-xl-5">
      <div class="row">
        <div class="col-md-4 text-center mb-5 mb-md-0">
          <div class="service-promotion__icon mb-4">
            <svg width="52" height="52" viewBox="0 0 52 52" fill="none" xmlns="http://www.w3.org/2000/svg"><use href="#icon_shipping" /></svg>
          </div>
          <h3 class="service-promotion__title fs-6 text-uppercase">Fast And Free Delivery</h3>
          <p class="service-promotion__content text-secondary">Free delivery for all orders over $140</p>
        </div><!-- /.col-md-4 text-center-->

        <div class="col-md-4 text-center mb-5 mb-md-0">
          <div class="service-promotion__icon mb-4">
            <svg width="53" height="52" viewBox="0 0 53 52" fill="none" xmlns="http://www.w3.org/2000/svg"><use href="#icon_headphone" /></svg>
          </div>
          <h3 class="service-promotion__title fs-6 text-uppercase">24/7 Customer Support</h3>
          <p class="service-promotion__content text-secondary">Friendly 24/7 customer support</p>
        </div><!-- /.col-md-4 text-center-->

        <div class="col-md-4 text-center mb-4 pb-1 mb-md-0">
          <div class="service-promotion__icon mb-4">
            <svg width="52" height="52" viewBox="0 0 52 52" fill="none" xmlns="http://www.w3.org/2000/svg"><use href="#icon_shield" /></svg>
          </div>
          <h3 class="service-promotion__title fs-6 text-uppercase">Money Back Guarantee</h3>
          <p class="service-promotion__content text-secondary">We return money within 30 days</p>
        </div><!-- /.col-md-4 text-center-->
      </div><!-- /.row -->
    </section>
   
  </main>
@include('layouts.footer')
