<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use App\Models\AdminModels\Product;

class Order extends Model
{
    protected $fillable = ['user_id', 'billing_id', 'order_id', 'product_id', 'qty', 'mrp', 'total', 'coupon_code', 'coupon_discount', 'payment_method', 'payment_status', 'order_status', 'expected_date'];

    public function billing(){
       return $this->belongsTo(Billing::class, 'billing_id', 'id'); 
    }

    public function product(){
       return $this->belongsTo(Product::class, 'product_id', 'id'); 
    }
}
