<?php

namespace App\Models\AdminModels;

use Illuminate\Database\Eloquent\Model;

class Product extends Model
{
    protected $fillable = [
        'category_id', 'sub_category_id', 'child_category_id', 'brand_id',
        'name', 'product_id', 'sub_sku', 'sold', 'stock', 'slug', 'mrp', 'selling_price', 'discount',
        'size', 'color', 'sku', 'hsn_code',
        'product_highlights', 'product_description',
        'length', 'breadth', 'height', 'weight',
        'country_of_origin', 'manufacturer_details', 'importer_details', 'packer_details',
        'meta_title', 'meta_description', 'meta_keywords',
        'tags', 'note', 'status', 'featured_image', 'bulk_images'
    ];
    
    public function category(){
       return $this->belongsTo(Category::class, 'category_id', 'id');
    }

    public function subCategory(){
       return $this->belongsTo(SubCategory::class, 'sub_category_id', 'id');
    }

    public function childCategory(){
       return $this->belongsTo(ChildCategory::class, 'child_category_id', 'id');
    }
    public function brand(){
       return $this->belongsTo(Brand::class, 'brand_id', 'id');
    }

    // protected $casts = [
    //     'bulk_images' => 'array',
    //     'status' => 'boolean',
    // ];
}

