<?php

namespace App\Http\Controllers;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use App\Mail\verifyOtp;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Session;
use App\Models\User;
use App\Models\Cart;

use Illuminate\Http\Request;

class userController
{
    public function userLogin(){
        return view('login');
    }

    public function userRegister(){
        return view('register');
    }

    public function userLoginSave(Request $request)
    {
        $request->validate([
            'email' => 'required|email',
            'password' => 'required|min:6'
        ]);

        $user = User::where('email', $request->email)
        ->where('is_verified', '!=', 0)
        ->first();
        
        $userId = Session::get('guest_session_id');
            if ($user) {
            $guestCart = Cart::where('user_id', $userId)->get();

            foreach ($guestCart as $cartItem) {
                // Check if product already exists in logged-in user's cart
                $existingCartItem = Cart::where('user_id', $user->id)
                    ->where('product_id', $cartItem->product_id)
                    ->first();

                if ($existingCartItem) {
                    // If exists, increase quantity
                    $existingCartItem->quantity += $cartItem->quantity;
                    $existingCartItem->save();

                    // Remove the guest cart item
                    $cartItem->delete();
                } else {
                    // If not exists, just transfer ownership
                    $cartItem->user_id = $user->id;
                    $cartItem->save();
                }
            }
        }
        if ($user && Hash::check($request->password, $user->password)) {
           Auth::guard('user')->login($user);
            $request->session()->regenerate(); 
            $redirect = $request->input('redirect', url('/'));
            return redirect()->to($redirect)->with('success', 'Login successful.');

        }

        return back()->with('error', 'Invalid credentials.');
    }

    public function userRegisterSave(Request $request){

        $request->validate([
            'name' => 'required|string|max:255',
            'email' => 'required|email|unique:users,email',
            'mobile' => 'required|max:10|unique:users,mobile',
            'password' => 'required|string|min:6'
        ]);
        $otp = rand(100000, 999999);
        $user = User::create([
            'name' => $request->name,
            'role' => 2,
            'email' => $request->email,
            'mobile' => $request->mobile,
            'password' => bcrypt($request->password),
            'otp' => $otp,
            'is_verified' => false
        ]);
        $data = [
            'otp' => $otp,
            'email' => $request->email
        ];

        Mail::to($request->email)->send(new verifyOtp($data));
        return redirect()->route('verify.otp.form')->with('email', $request->email);

    }

    public function logout(){

        Auth::guard('user')->logout();
        return redirect('/');
    }

    public function verifyOtpForm(){
       return view('verify-otp');
    }

    public function verifyOtp(Request $request)
    {
        $request->validate([
            'email' => 'required|email',
            'otp' => 'required|digits:6',
        ]);

        $user = User::where('email', $request->email)->where('otp', $request->otp)->first();

        if ($user) {
            $user->is_verified = 1;
            $user->otp = null;
            $user->save();

            return redirect()->route('user.login')->with('success', 'Account verified! Please login.');
        }

            return back()->with('error', 'Invalid OTP.')->with('email', $request->email);
    }

    public function myAccount(){

        $id = Auth::guard('user')->user()->id;
        $user = User::where('id', $id)->first();
        return view('my-account', compact('user'));
    }

    public function updateAccount(Request $request, $user_id)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'email' => 'required|email|unique:users,email,' . $user_id,
            'mobile' => 'required|max:10|unique:users,mobile,' . $user_id
        ]);

        $user = User::findOrFail($user_id);
        $user->name = $request->name;
        $user->email = $request->email;
        $user->mobile = $request->mobile;

        if ($user->save()) {
            return back()->with('success', 'Your account has been updated successfully!');
        } else {
            return back()->with('error', 'Your account was not updated!');
        }
    }
    public function changePassword(){
       return view('change-password');
    }
    
    public function updatePassword(Request $request)
    {
        $request->validate([
            'old_password' => 'required',
            'new_password' => 'required|min:6',
            'confirm_password' => 'required|same:new_password'

        ]);

        $user = Auth::guard('user')->user();

        if (!Hash::check($request->old_password, $user->password)) {
            return back()->withErrors(['old_password' => 'Old password does not match.']);
        }

        $user->password = Hash::make($request->new_password);
        $user->save();

        return back()->with('success', 'Password updated successfully.');
    }



}
