<?php

namespace App\Http\Controllers\AdminControllers;

use Illuminate\Http\Request;
use App\Models\AdminModels\Category;
use App\Models\AdminModels\SubCategory;
use App\Models\AdminModels\ChildCategory;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Str;

class SubCategoryController
{
    public function subCategoryList(){
        $sub_category = SubCategory::select('*')->with('category')->get();
        // dd($sub_category);
        return view('admin.sub-category-list', ['sub_category'=>$sub_category]);
    }

    public function subCategoryAdd(){
        $categories = Category::select('*')->get();
        return view('admin.sub-category-add', ['categories'=>$categories]);
    }

    public function subCategorySave(Request $request){

        $validated = $request->validate([
            'name' => 'required|string|max:255',
            'category_id' => 'required|integer',
            'status' => 'required|string|max:50',
            'meta_title' => 'required|string|max:255',
            'image' => 'required|image|mimes:jpeg,png,jpg,gif,svg|max:2048',
        ]);

        $sub_category = new SubCategory;
        $sub_category->name = $request->name;
        $sub_category->category_id = $request->category_id;
        $sub_category->status = $request->status;
        $sub_category->slug = Str::slug($request->name);
        $sub_category->meta_title = $request->meta_title;
        $sub_category->meta_description = $request->meta_description;
        $sub_category->meta_keywords = $request->meta_keywords;


        if ($request->hasFile('image')) {

            $image = $request->file('image');
            $imageName = time() . '_' . $image->getClientOriginalName();
            $image->move(public_path('uploads/sub-categories'), $imageName);
            $sub_category->image = $imageName;
        }
        $sub_category->save();

        return redirect()->route('sub.category.list');

    }

    public function subCategoryEdit($id){
        $categories = Category::select('*')->get();
        $sub_category = SubCategory::where('id', $id)->first();
        return view('admin.sub-category-edit', ['sub_category'=>$sub_category, 'categories'=>$categories]);
    }

    public function subCategoryUpdate(Request $request, $id)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'category_id' => 'required|integer',
            'status' => 'required|string|max:50',
            'meta_title' => 'required|string|max:255',
            'image' => 'image|mimes:jpeg,png,jpg,gif,svg|max:2048',
        ]);

        $sub_category = SubCategory::findOrFail($id);
        $sub_category->name = $request->name;
        $sub_category->category_id = $request->category_id;
        $sub_category->status = $request->status;
        $sub_category->slug = Str::slug($request->name);
        $sub_category->meta_title = $request->meta_title;
        $sub_category->meta_description = $request->meta_description;
        $sub_category->meta_keywords = $request->meta_keywords;

        if ($request->hasFile('image')) {

            $oldImage = public_path('uploads/sub-categories/' . $sub_category->image);
            if (File::exists($oldImage)) {
                File::delete($oldImage);
            }
            $image = $request->file('image');
            $imageName = time() . '_' . $image->getClientOriginalName();
            $image->move(public_path('uploads/sub-categories'), $imageName);
            $sub_category->image = $imageName;
        }

        $sub_category->save();

        return redirect()->route('sub.category.list')->with('success', 'Category updated successfully!');
    }

    public function subCategoryDelete(Request $request, $id)
    {
         $sub_category =  SubCategory::where('id', $id)->first();
         $sub_category->delete();
         $childcategory = ChildCategory::where('sub_category_id', $id)->first();
        if($childcategory){
            $childcategory->delete();
        }
         return redirect()->route('sub.category.list')->with('success', 'Sub category successfully deleted!');
    }
}
