<?php

namespace App\Http\Controllers\AdminControllers;

use Illuminate\Http\Request;
use App\Models\AdminModels\ProductVariantType;

class ProductVariantTypeController
{
   
    public function productVariantTypeAdd(){
        return view('admin.product-variant-type.add');
    }

    public function productVariantTypeSave(Request $request){

        $validated = $request->validate([
            'variation_type' => 'required|string|max:255',
            'status' => 'required|string|max:50',
        ]);

        $productVariant = new ProductVariantType();
        $productVariant->variation_type = $request->variation_type;
        $productVariant->status = $request->status;
        $productVariant->save();

        return redirect()->route('product.variant.type.list')->with('success', 'product variant inserted successfully!');
    }

    public function productVariantTypeList(){

        $product_variant_type = ProductVariantType::select('*')->get();
        return view('admin.product-variant-type.list', ['product_variant_type'=>$product_variant_type]);

    }

    public function productVariantTypeEdit($id){
        $productVariant = ProductVariantType::where('id', $id)->first();
        return view('admin.product-variant-type.edit', ['productVariant'=>$productVariant]);
    }

    public function productVariantTypeUpdate(Request $request, $id)
    {
        $request->validate([
            'variation_type' => 'required|string|max:255',
            'status' => 'required|string|max:50',
        ]);

        $productVariant = ProductVariantType::findOrFail($id);
        $productVariant->variation_type = $request->variation_type;
        $productVariant->status = $request->status;

        $productVariant->save();

        return redirect()->route('product.variant.type.list')->with('success', 'product variant type successfully!');
    }


    public function productVariantTypeDelete($id){
        $productVariant = ProductVariantType::where('id', $id)->first();
        $productVariant->delete();
        return redirect()->route('product.variant.type.list')->with('success', 'product variant type successfully deleted');
    }
}
