<?php

namespace App\Http\Controllers\AdminControllers;

use Illuminate\Http\Request;
use App\Models\AdminModels\Category;
use App\Models\AdminModels\CouponCode;

class CouponCodeController
{
    public function couponCodeAdd(){

        $categories = Category::select('*')->get();

        return view('admin.coupon-code-add', ['categories'=>$categories]);
    }

   public function couponCodeList(){
       $coupon_code = CouponCode::select('*')->orderBy('id', 'DESC')->get();
       return view('admin.coupon-code-list', ['coupon_code'=>$coupon_code]);
   }

   public function couponCodeSave(Request $request){

    $validated = $request->validate([
            'coupon_code' => 'required|string',
            'max_discount' => 'required|integer|max:100',
            'max_discount_value' => 'required|integer',
            'min_card_value' => 'required|integer',
            'applicable_on' => 'required|string',
            'applicable_times' => 'required|integer',
            'expiry_date' => 'required',
        ]);

        $coupon_code = new CouponCode;
        $coupon_code->coupon_code = $request->coupon_code;
        $coupon_code->max_discount = $request->max_discount;
        $coupon_code->max_discount_value = $request->max_discount_value;
        $coupon_code->min_card_value = $request->min_card_value;
        $coupon_code->applicable_on = $request->applicable_on;
        $coupon_code->applicable_times = $request->applicable_times;
        $coupon_code->expiry_date = $request->expiry_date;
        $coupon_code->save();

        return redirect()->route('coupon.code.list');
    }
    
    public function couponCodeEdit($id){
        $categories = Category::select('*')->get();
        $coupon_code = CouponCode::where('id', $id)->first();
        return view('admin.coupon-code-edit', ['coupon_code'=>$coupon_code, 'categories'=>$categories]);
    }

    public function couponCodeUpdate(Request $request, $id)
    {
        $validated = $request->validate([
            'coupon_code' => 'required|string',
            'max_discount' => 'required|integer|max:100',
            'max_discount_value' => 'required|integer|lte:min_card_value',
            'min_card_value' => 'required|integer',
            'applicable_on' => 'required|string',
            'applicable_times' => 'required|integer',
            'expiry_date' => 'required',
        ]);

        $coupon_code = CouponCode::findOrFail($id);
        $coupon_code->coupon_code = $request->coupon_code;
        $coupon_code->max_discount = $request->max_discount;
        $coupon_code->max_discount_value = $request->max_discount_value;
        $coupon_code->min_card_value = $request->min_card_value;
        $coupon_code->applicable_on = $request->applicable_on;
        $coupon_code->applicable_times = $request->applicable_times;
        $coupon_code->expiry_date = $request->expiry_date;
        $coupon_code->save();

        return redirect()->route('coupon.code.list');
    }

    public function couponCodeDelete(Request $request, $id)
    {
         $coupon_code =  CouponCode::where('id', $id)->first();
         $coupon_code->delete();
        
         return redirect()->route('coupon.code.list')->with('success', 'Sub coupon code successfully deleted!');
    }
}
