<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Login</title>

    <!-- Bootstrap 5 CDN -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">

    <style>
        body {
            background: url("<?php echo e(asset('admin/assets/images/dec.png')); ?>") no-repeat center center fixed;
            background-size: contain;
        }
        .login-container {
            height: 100vh;
        }
        .login-card {
            width: 100%;
            max-width: 400px;
            background: rgba(255, 255, 255, 0.95);
            border-radius: 10px;
        }
        .login-logo {
            width: 100px;
            margin: 0 auto 15px;
            display: block;
        }
        .custom-btn {
            background-color: black;
            border: none;
            color: #fff;
        }

        .custom-btn:hover {
            background-color: white;
            color: #000;
        }
    </style>
</head>
<body>
    <div class="container d-flex align-items-center justify-content-center login-container">
        <div class="card login-card shadow p-4">
            <div class="card-body">
                <!-- Logo -->
                <!-- <img src="<?php echo e(asset('assets/img/images/432536.png')); ?>" alt="Logo" class="login-logo"> -->
                <h2 class=" card-title text-center">Home</h2>
                <h3 class="card-title text-center mb-4">Decor</h3>

                <?php if(session('error')): ?>
                    <div class="alert alert-danger">
                        <?php echo e(session('error')); ?>

                    </div>
                <?php endif; ?>

                <form method="POST" action="<?php echo e(route('login.submit')); ?>">
                    <?php echo csrf_field(); ?>
                    <div class="mb-3">
                        <label for="email" class="form-label">Email address</label>
                        <input type="email" class="form-control" name="email" id="email" required>
                    </div>

                    <div class="mb-3">
                        <label for="password" class="form-label">Password</label>
                        <div class="position-relative auth-pass-inputgroup mb-3">
                        <input type="password" class="form-control" name="password" id="password" required>
                        <button type="button" class="btn btn-link position-absolute end-0 top-0 text-decoration-none text-muted password-addon material-shadow-none" id="togglePassword">
                            <i class="fas fa-eye" id="eyeIcon"></i>
                        </button>
                        </div>
                    </div>

                    <div class="d-grid">
                        <button type="submit" class="btn custom-btn">Login</button>
                    </div>
                </form>

            </div>
        </div>
    </div>

    <!-- Optional Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/js/all.min.js"></script>

    <script>
        const togglePassword = document.querySelector('#togglePassword');
        const password = document.querySelector('#password');
        const eyeIcon = document.querySelector('#eyeIcon');

        togglePassword.addEventListener('click', function (e) {
            // toggle the type attribute
            const type = password.getAttribute('type') === 'password' ? 'text' : 'password';
            password.setAttribute('type', type);

            // toggle the eye / eye-slash icon
            if (type === 'password') {
                eyeIcon.classList.remove('fa-eye-slash');
                eyeIcon.classList.add('fa-eye');
            } else {
                eyeIcon.classList.remove('fa-eye');
                eyeIcon.classList.add('fa-eye-slash');
            }
        });
    </script>
</body>
</html>
<?php /**PATH C:\xampp\htdocs\dec\resources\views/admin/login.blade.php ENDPATH**/ ?>