<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\AdminControllers\AuthController;
use App\Http\Controllers\AdminControllers\CategoryController;
use App\Http\Controllers\AdminControllers\SubCategoryController;
use App\Http\Controllers\AdminControllers\ChildController;
use App\Http\Controllers\AdminControllers\BrandController;
use App\Http\Controllers\AdminControllers\ProductController;
use App\Http\Controllers\AdminControllers\CouponCodeController;
use App\Http\Controllers\AdminControllers\SettingController;
use App\Http\Controllers\AdminControllers\OrderController;
use App\Http\Controllers\AdminControllers\ProductVariantController;

// Route::get('/', function () {
//     return view('welcome');
// });

Route::prefix('admin')->group(function () {

Route::get('/login', [AuthController::class, 'showLoginForm'])->name('login');
Route::post('/login', [AuthController::class, 'login'])->name('login.submit');
Route::post('/variant-value/store', [ProductController::class, 'variantValueStore'])->name('variant.value.store');

Route::middleware(['auth:admin'])->group(function () {

    Route::get('/web-setting', [SettingController::class, 'webSetting'])->name('web.setting');
    Route::post('/guest-update', [SettingController::class, 'guestUpdate'])->name('guest.update');
    Route::get('/order-list', [OrderController::class, 'orderList'])->name('order.list');
    Route::get('/orders-by-status', [OrderController::class, 'ordersByStatus'])->name('orders.by.status');
    Route::get('/orders-view/{id}', [OrderController::class, 'ordersView'])->name('orders.view');
    Route::post('/orders/update-status', [OrderController::class, 'updateStatus'])->name('orders.update.status');
    
    Route::get('/dashboard', [AuthController::class, 'dashboard'])->name('dashboard');
    Route::get('/index', [CategoryController::class, 'index'])->name('index');
    Route::get('/category', [CategoryController::class, 'categoryAdd'])->name('category.add');
    Route::get('/category-list', [CategoryController::class, 'categoryList'])->name('category.list');
    Route::post('/category-save', [CategoryController::class, 'categorySave'])->name('category.save');
    Route::get('/category/edit/{id}', [CategoryController::class, 'categoryEdit'])->name('category.edit');
    Route::post('/category/update/{id}', [CategoryController::class, 'categoryUpdate'])->name('category.update');
    Route::get('/category/delete/{id}', [CategoryController::class, 'categoryDelete'])->name('category.delete');

    Route::get('/sub-category-list', [SubCategoryController::class, 'subCategoryList'])->name('sub.category.list');
    Route::get('/sub-category-add', [SubCategoryController::class, 'subCategoryAdd'])->name('sub.category.add');
    Route::post('/sub-category-save', [SubCategoryController::class, 'subCategorySave'])->name('sub.category.save');
    Route::get('/sub-category/edit/{id}', [SubCategoryController::class, 'subCategoryEdit'])->name('sub.category.edit');
    Route::post('/sub-category/update/{id}', [SubCategoryController::class, 'subCategoryUpdate'])->name('sub.category.update');
    Route::get('/sub-category/delete/{id}', [SubCategoryController::class, 'subCategoryDelete'])->name('sub.category.delete');

    Route::get('/child-category-list', [ChildController::class, 'childCategoryList'])->name('child.category.list');
    Route::get('/child-category-add', [ChildController::class, 'childCategoryAdd'])->name('child.category.add');
    Route::post('/child-category-save', [ChildController::class, 'childCategorySave'])->name('child.category.save');
    Route::get('/child-category/edit/{id}', [ChildController::class, 'childCategoryEdit'])->name('child.category.edit');
    Route::post('/child-category/update/{id}', [ChildController::class, 'childCategoryUpdate'])->name('child.category.update');
    Route::get('/child-category/delete/{id}', [ChildController::class, 'childCategoryDelete'])->name('child.category.delete');

    Route::get('/brand-list', [BrandController::class, 'brandList'])->name('brand.list');
    Route::get('/brand-add', [BrandController::class, 'brandAdd'])->name('brand.add');
    Route::post('/brand-save', [BrandController::class, 'brandSave'])->name('brand.save');
    Route::get('/brand/edit/{id}', [BrandController::class, 'brandEdit'])->name('brand.edit');
    Route::post('/brand/update/{id}', [BrandController::class, 'brandUpdate'])->name('brand.update');
    Route::get('/brand/delete/{id}', [BrandController::class, 'brandDelete'])->name('brand.delete');

    Route::get('/product-list', [ProductController::class, 'productList'])->name('product.list');
    Route::get('/product-add', [ProductController::class, 'productAdd'])->name('product.add');
    Route::post('/product-save', [ProductController::class, 'productSave'])->name('product.save');

    Route::get('/product/edit/{id}', [ProductController::class, 'productEdit'])->name('product.edit');
    Route::post('/product/update/{id}', [ProductController::class, 'productUpdate'])->name('product.update');
    Route::get('/product/delete/{id}', [ProductController::class, 'productDelete'])->name('product.delete');

    Route::get('/attribute-list', [ProductVariantController::class, 'attributeList'])->name('attribute.list');
    Route::get('/attribute-add', [ProductVariantController::class, 'attributeAdd'])->name('attribute.add');
    Route::post('/attribute-save', [ProductVariantController::class, 'attributeSave'])->name('attribute.save');

    Route::get('/attribute/edit/{id}', [ProductVariantController::class, 'attributeEdit'])->name('attribute.edit');
    Route::post('/attribute/update/{id}', [ProductVariantController::class, 'attributeUpdate'])->name('attribute.update');
    Route::get('/attribute/delete/{id}', [ProductVariantController::class, 'attributeDelete'])->name('attribute.delete');

    Route::get('/attribute-value-list', [ProductVariantController::class, 'attributeValueList'])->name('attribute.value.list');
    Route::get('/attribute-value-add', [ProductVariantController::class, 'attributeValueAdd'])->name('attribute.value.add');
    Route::post('/attribute-value-save', [ProductVariantController::class, 'attributeValueSave'])->name('attribute.value.save');

    Route::get('/attribute-value/edit/{id}', [ProductVariantController::class, 'attributeValueEdit'])->name('attribute.value.edit');
    Route::post('/attribute-value/update/{id}', [ProductVariantController::class, 'attributeValueUpdate'])->name('attribute.value.update');
    Route::get('/attribute-value/delete/{id}', [ProductVariantController::class, 'attributeValueDelete'])->name('attribute.value.delete');

    // Route::get('/product-variant-type-list', [ProductVariantTypeController::class, 'productVariantTypeList'])->name('product.variant.type.list');

    Route::get('/product-variant-add/{id}', [ProductController::class, 'productVariantAdd'])->name('product.variant.add');
    Route::post('/product-variant-save', [ProductController::class, 'productVariantSave'])->name('product.variant.save');

    Route::get('/coupon-code-list', [CouponCodeController::class, 'couponCodeList'])->name('coupon.code.list');
    Route::get('/coupon-code-add', [CouponCodeController::class, 'couponCodeAdd'])->name('coupon.code.add');
    Route::post('/coupon-code-save', [CouponCodeController::class, 'couponCodeSave'])->name('coupon.code.save'); 
    Route::get('/coupon-code/delete/{id}', [CouponCodeController::class, 'couponCodeDelete'])->name('coupon.code.delete'); 
    Route::get('/coupon-code/edit/{id}', [CouponCodeController::class, 'couponCodeEdit'])->name('coupon.code.edit');
    Route::post('/coupon-code/update/{id}', [CouponCodeController::class, 'couponCodeUpdate'])->name('coupon.code.update'); 

    Route::get('/menu-order-list', [SettingController::class, 'menuOrderList'])->name('menu.order.list');
    Route::get('/menu-order-add', [SettingController::class, 'menuOrderAdd'])->name('menu.order.add');
    Route::post('/menu-order-save', [SettingController::class, 'menuOrderSave'])->name('menu.order.save'); 
    Route::get('/menu-order/delete/{id}', [SettingController::class, 'menuOrderDelete'])->name('menu.order.delete'); 
    Route::get('/menu-order/edit/{id}', [SettingController::class, 'menuOrderEdit'])->name('menu.order.edit');
    Route::post('/menu-order/update/{id}', [SettingController::class, 'menuOrderUpdate'])->name('menu.order.update');

});
Route::get('/logout', [AuthController::class, 'logout'])->name('logout');
});

Route::get('/get-subcategories/{category_id}', [ProductController::class, 'getSubcategories']);
Route::get('/get-childcategories/{subcategory_id}', [ProductController::class, 'getChildcategories']);

require base_path('routes/page.php');