@if($product->isEmpty())
              <div class="product-card-wrapper trans">
                  <h3>No data found.</h3>
              </div>                                                                
                @else
                @php
                    $shownProducts = [];
                @endphp

            @foreach($product as $item)
                                
                    <div class="product-card-wrapper trans" class="prod-list">
                      <div class="product-card mb-3 mb-md-4 mb-xxl-5">
                        <div class="pc__img-wrapper">
                          <div class="swiper-container background-img js-swiper-slider" data-settings='{"resizeObserver": true}'>
                            <div class="swiper-wrapper">
                              @if(!empty($item->bulk_images) && is_array(json_decode($item->bulk_images, true)))
                                @foreach(json_decode($item->bulk_images, true) as $image)
                                  <div class="swiper-slide">
                                    <a href="{{ route('products', ['category' => $item->category->slug, 'product_id' => $item->product_id, 'sub_sku' => $item->sub_sku, 'slug' => $item->slug ?? '', 'size' => $item->size ?? '', 'color' => $item->color ?? '']) }}">
                                      <img loading="lazy" src="{{ asset('uploads/products/' . $image) }}" width="330" height="400" alt="{{ $item->name }}" class="pc__img">
                                    </a>
                                  </div>
                                @endforeach
                              @else
                              <div class="swiper-slide">
                                <a href="{{ route('products', ['category' => $item->category->slug, 'product_id' => $item->product_id, 'sub_sku' => $item->sub_sku, 'slug' => $item->slug ?? '', 'size' => $item->size ?? '', 'color' => $item->color ?? '']) }}">
                                  <img loading="lazy" src="{{ asset('uploads/products/' . $item->featured_image) }}" width="330" height="400" alt="{{ $item->name ?? ''}}" class="pc__img">
                                </a>
                              </div>
                              @endif
                            </div>
                            <span class="pc__img-prev"><svg width="7" height="11"><use href="#icon_prev_sm" /></svg></span>
                            <span class="pc__img-next"><svg width="7" height="11"><use href="#icon_next_sm" /></svg></span>
                          </div>
                        </div>

                        <div class="pc__info position-relative">
                          <h6 class="pc__title">
                            <a href="{{ route('products', ['category' => $item->category->slug, 'product_id' => $item->product_id, 'sub_sku' => $item->sub_sku, 'slug' => $item->slug ?? '', 'size' => $item->size ?? '', 'color' => $item->color ?? '']) }}">
                              {{ $item->name ?? ''}}
                            </a>
                          </h6>
                          <div class="product-card__price d-flex justify-content-center">
                            @if(isset($item->selling_price) && $item->selling_price != 0)
                              <span class="money price price-old">Rs. {{ $item->mrp ?? ''}}</span>
                              <span class="money price pr-color">Rs. {{ $item->selling_price ?? ''}}</span>
                            @else
                              <span class="money price">Rs. {{ $item->mrp ?? ''}}</span>
                            @endif
                          </div>
                          <button class="pc__btn-wl position-absolute top-0 end-0 bg-transparent border-0 js-add-wishlist" title="Add To Wishlist">
                            <svg width="16" height="16"><use href="#icon_heart" /></svg>
                          </button>
                        </div>
                      </div>
                    </div>
                
            @endforeach

            @endif