@include('admin.layouts.header')
@include('admin.layouts.sidebar')
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css">

        <!-- ============================================================== -->
        <!-- Start right Content here -->
        <!-- ============================================================== -->
        <div class="main-content">

            <div class="page-content">
                <div class="container-fluid">

                    <!-- start page title -->
                    <div class="row">
                        <div class="col-12">
                            <div class="page-title-box d-sm-flex align-items-center justify-content-between bg-galaxy-transparent">
                                <h4 class="mb-sm-0">Add Product Variants</h4>

                                <div class="page-title-right">
                                    <ol class="breadcrumb m-0">
                                        <li class="breadcrumb-item"><a href="javascript: void(0);">Forms</a></li>
                                        <li class="breadcrumb-item active">Add Product Variants</li>
                                    </ol>
                                </div>

                            </div>
                        </div>
                    </div>
                    <!-- end page title -->

                    <div class="row">
                        <div class="col-lg-12">
                            <div class="card">
                                <div class="card-header align-items-center d-flex">
                                    <h4 class="card-title mb-0 flex-grow-1">Input Example</h4>

                                </div><!-- end card header -->
                                <form action="{{ route('product.variant.save') }}" method="post" enctype="multipart/form-data">
                                    @csrf
                                    <div class="card-body">
                                        <div class="live-preview">
                                            <div class="row gy-4">

                                            <!-- add variant values -->

                                            <div class="col-12">
                                                <label class="form-label">Product Variant</label>
                                                <div id="addon-wrapper">
                                            <div class="row addon-row mb-4 p-3 border rounded">
                                                <input type="hidden" name="id" class="form-control" value="{{ $product->id }}">
                                                    <div class="col-md-2">
                                                        <label class="form-label">Size</label>
                                                        <input type="text" name="addons[0][size]" class="form-control" placeholder="Enter Size" value="{{ old('addons.0.size') }}" data-size>
                                                        @error('addons.0.size')
                                                            <p class="text-danger">{{ $message }}</p>
                                                        @enderror
                                                    </div>
                                                    <div class="col-md-2">
                                                        <label class="form-label">Colour</label>
                                                        <input type="text" name="addons[0][color]" class="form-control" placeholder="Enter Colour" value="{{ old('addons.0.color') }}" data-color>
                                                        @error('addons.0.color')
                                                        <p class="text-danger">{{ $message }}</p>
                                                        @enderror
                                                    </div>
                                                    <div class="col-md-2">
                                                        <label class="form-label">MRP</label>
                                                        <input type="number" name="addons[0][mrp]" class="form-control" value="{{ $product->mrp ?? '' }}" data-type="mrp">
                                                    </div>
                                                    <div class="col-md-2">
                                                        <label class="form-label">Selling Price</label>
                                                        <input type="number" step="0.01" name="addons[0][selling_price]" class="form-control" data-type="selling_price" value="{{ rtrim(rtrim(number_format($product->selling_price, 2, '.', ''), '0'), '.') }}">
                                                    </div>
                                                    <div class="col-md-2">
                                                        <label class="form-label">Discount</label>
                                                        <input type="number" step="0.01" name="addons[0][discount]" class="form-control" data-type="discount" value="{{ rtrim(rtrim(number_format($product->discount, 2, '.', ''), '0'), '.') }}">
                                                    </div>
                                                    <div class="col-md-2">
                                                        <label class="form-label">Stock</label>
                                                        <input type="number" name="addons[0][stock]" class="form-control" value="{{ $product->stock ?? '' }}">
                                                    </div>
                                                    <div class="col-md-3">
                                                        <label class="form-label">Feature Image</label>
                                                        <input type="file" name="addons[0][featured_image]" class="form-control">
                                                        @error('addons.0.featured_image')
                                                        <p class="text-danger">{{ $message }}</p>
                                                        @enderror
                                                    </div>
                                                    <div class="col-md-2 d-flex align-items-center" style="margin-top:22px">
                                                        <button type="button" class="btn btn-success" onclick="addAddonRow()">+</button>
                                                    </div>
                                                </div>
                                            </div>

                                            </div>
                                                    <div style="text-align: center;">
                                                        <button type="submit" class="btn btn-primary">Submit</button>
                                                    </div>
                                                </div>

                                            </div>
                                            <!--end row-->
                                        </div>

                                    </div>
                                </form>

                        <div class="row">
                    
                            <div class="col-xl-12">
                                <div class="card">
                                    <div class="card-header align-items-center d-flex">
                                        <h4 class="card-title mb-0 flex-grow-1">Product Variant List</h4>
                                    </div><!-- end card header -->

                                    <div class="card-body">
                                        
                                        <div class="live-preview">
                                            <div class="table-responsive">
                                                <table id="example" class="table table-striped table-nowrap align-middle mb-0">
                                                    <thead>
                                                        <tr>
                                                            <th scope="col">ID</th>
                                                            <th scope="col">Size</th>
                                                            <th scope="col">Color</th>
                                                            <th scope="col">Mrp</th>
                                                            <th scope="col">Selling Price</th>
                                                            <th scope="col">Discount</th>
                                                            <th scope="col">Stock</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                    @if($product_variant == "" && $product_variant->isEmpty())
                                                    <tr>
                                                    <td colspan="5" class="text-center">No data found.</td>
                                                    </tr>
                                                    @else
                                                    @foreach($product_variant as $key => $item)
                                                        <tr>
                                                            <td class="fw-medium">{{ $key + 1 }}</td>
                                                            <td>{{ $item->size }}</td>
                                                            <td>{{ $item->color }}</td>
                                                            <td>{{ $item->mrp }}</td>
                                                            <td>{{ $item->selling_price }}</td>
                                                            <td>{{ $item->discount }}</td>
                                                            <td>{{ $item->stock }}</td>
                                                            
                                                        </tr>
                                                    @endforeach    
                                                    @endif       
                                                    </tbody>
                                                </table>
                                                
                                            </div>
                                            
                                            <div class="d-flex justify-content-end mt-3">
                                                <nav>
                                                    <ul class="pagination">
                                                        {{-- Previous Page Link --}}
                                                        @if ($product_variant->onFirstPage())
                                                            <li class="page-item disabled"><span class="page-link">Previous</span></li>
                                                        @else
                                                            <li class="page-item">
                                                                <a class="page-link" href="{{ $product_variant->previousPageUrl() }}" rel="prev">Previous</a>
                                                            </li>
                                                        @endif

                                                        {{-- Pagination Elements --}}
                                                        @for ($i = 1; $i <= $product_variant->lastPage(); $i++)
                                                            @if ($i == $product_variant->currentPage())
                                                                <li class="page-item active"><span class="page-link">{{ $i }}</span></li>
                                                            @elseif ($i == 1 || $i == $product_variant->lastPage() || ($i >= $product_variant->currentPage() - 1 && $i <= $product_variant->currentPage() + 1))
                                                                <li class="page-item"><a class="page-link" href="{{ $product_variant->url($i) }}">{{ $i }}</a></li>
                                                            @elseif ($i == $product_variant->currentPage() - 2 || $i == $product_variant->currentPage() + 2)
                                                                <li class="page-item disabled"><span class="page-link">...</span></li>
                                                            @endif
                                                        @endfor

                                                        {{-- Next Page Link --}}
                                                        @if ($product_variant->hasMorePages())
                                                            <li class="page-item">
                                                                <a class="page-link" href="{{ $product_variant->nextPageUrl() }}" rel="next">Next</a>
                                                            </li>
                                                        @else
                                                            <li class="page-item disabled"><span class="page-link">Next</span></li>
                                                        @endif
                                                    </ul>
                                                </nav>
                                            </div>
                                       
                                        </div>
                                        
                                    </div><!-- end card-body -->
                                </div><!-- end card -->
                            </div>
                        </div>

                            </div>
                        </div>
                        <!--end col-->
                    </div>
            
                    <!-- end page title -->

@include('admin.layouts.footer')
<script>
    let addonIndex = 1;
    function bindAddonCalculationEvents(container) {
        const mrpInput = container.querySelector('[data-type="mrp"]');
        const sellingInput = container.querySelector('[data-type="selling_price"]');
        const discountInput = container.querySelector('[data-type="discount"]');

        if (!mrpInput || !sellingInput || !discountInput) return;

        function calculateSellingPrice() {
            const mrp = parseFloat(mrpInput.value);
            const discount = parseFloat(discountInput.value);
            if (!isNaN(mrp) && !isNaN(discount)) {
                sellingInput.value = (mrp - (mrp * discount / 100)).toFixed(2);
            }
        }

        function calculateDiscount() {
            const mrp = parseFloat(mrpInput.value);
            const selling = parseFloat(sellingInput.value);
            if (!isNaN(mrp) && !isNaN(selling) && mrp !== 0) {
                discountInput.value = (((mrp - selling) / mrp) * 100).toFixed(2);
            }
        }

        mrpInput.addEventListener('input', function () {
            if (discountInput.value) calculateSellingPrice();
            else if (sellingInput.value) calculateDiscount();
        });

        discountInput.addEventListener('input', calculateSellingPrice);
        sellingInput.addEventListener('input', calculateDiscount);
    }

    document.addEventListener('DOMContentLoaded', function () {
        document.querySelectorAll('.addon-row').forEach(row => {
            bindAddonCalculationEvents(row);
        });
    });



    function addAddonRow() {
        const wrapper = document.getElementById('addon-wrapper');
        
        const lastRow = wrapper.querySelector('.addon-row:last-child');

        const requiredFields = lastRow.querySelectorAll('[data-size], [data-color], [data-mrp], [data-selling], [data-discount], [data-stock]');

        let isEmpty = true;
        for (let input of requiredFields) {
        if (input.value.trim() !== '') {
            isEmpty = false;
            break; // stop the loop as soon as one field is filled
        }
        }

        if (isEmpty) {
            alert('Please fill in the current variant row before adding a new one.');
            return;
        }

        const newRow = document.createElement('div');
        newRow.classList.add('row', 'addon-row', 'mb-4', 'p-3', 'border', 'rounded');

        newRow.innerHTML = `
            <div class="col-md-2">
                <label class="form-label">Size</label>
                <input type="text" name="addons[${addonIndex}][size]" class="form-control" placeholder="Enter Size" value="{{ old('addons.$addonIndex.size') }}" data-size>
                @error('addons.1.size')
                    <p class="text-danger">{{ $message }}</p>
                @enderror
            </div>
            <div class="col-md-2">
                <label class="form-label">Colour</label>
                <input type="text" name="addons[${addonIndex}][color]" class="form-control" placeholder="Enter Colour" value="{{ old('addons.$addonIndex.color') }}" data-color>
                @error('addons.1.color')
                    <p class="text-danger">{{ $message }}</p>
                @enderror
            </div>
            </div>
            <div class="col-md-2">
                <label class="form-label">MRP</label>
                <input type="number" name="addons[${addonIndex}][mrp]" class="form-control" value="{{ $product->mrp ?? '' }}" data-type="mrp">
            </div>
            <div class="col-md-2">
                <label class="form-label">Selling Price</label>
                <input type="number" step="0.01" name="addons[${addonIndex}][selling_price]" class="form-control" data-type="selling_price" value="{{ rtrim(rtrim(number_format($product->selling_price, 2, '.', ''), '0'), '.') }}">
            </div>
            <div class="col-md-2">
                <label class="form-label">Discount</label>
                <input type="number" step="0.01" name="addons[${addonIndex}][discount]" class="form-control" data-type="discount" value="{{ rtrim(rtrim(number_format($product->discount, 2, '.', ''), '0'), '.') }}">
            </div>
            <div class="col-md-2">
                <label class="form-label">Stock</label>
                <input type="number" name="addons[${addonIndex}][stock]" class="form-control" value="{{ $product->stock ?? '' }}">
            </div>
            <div class="col-md-3 mt-2">
                <label class="form-label">Feature Image</label>
                <input type="file" name="addons[${addonIndex}][featured_image]" class="form-control">
                @error('addons.1.featured_image')
                    <p class="text-danger">{{ $message }}</p>
                @enderror
            </div>
            </div>
            <div class="col-md-2 d-flex align-items-end mt-2">
                <button type="button" class="btn btn-danger" onclick="this.closest('.addon-row').remove()">−</button>
            </div>
        `;

        wrapper.appendChild(newRow);
        bindAddonCalculationEvents(newRow);
        addonIndex++;
    }
</script>

