@include('admin.layouts.header')
@include('admin.layouts.sidebar')
        <!-- ============================================================== -->
        <!-- Start right Content here -->
        <!-- ============================================================== -->
        <div class="main-content">

            <div class="page-content">
                <div class="container-fluid">

                    <!-- start page title -->
                    <div class="row">
                        <div class="col-12">
                            <div class="page-title-box d-sm-flex align-items-center justify-content-between bg-galaxy-transparent">
                                <h4 class="mb-sm-0">Add Products</h4>

                                <div class="page-title-right">
                                    <ol class="breadcrumb m-0">
                                        <li class="breadcrumb-item"><a href="javascript: void(0);">Forms</a></li>
                                        <li class="breadcrumb-item active">Add Products</li>
                                    </ol>
                                </div>

                            </div>
                        </div>
                    </div>
                    <!-- end page title -->

                    <div class="row">
                        <div class="col-lg-12">
                            <div class="card">
                                <div class="card-header align-items-center d-flex">
                                    <h4 class="card-title mb-0 flex-grow-1">Input Example</h4>
                                    
                                </div><!-- end card header -->
                                <form action="{{ route('product.update', $product->id) }}" method="post" enctype="multipart/form-data">
                                @csrf
                                <div class="card-body">
                                    <div class="live-preview">
                                        <div class="row gy-4">
                                            <div class="col-xxl-3 col-md-6">
                                                <div>
                                                    <label for="categorySelect" class="form-label">Category</label>
                                                    <select name="category_id" class="form-select" id="categorySelect">
                                                        <option value="">Select Category</option>
                                                        @foreach($categories as $category)
                                                            <option value="{{ $category->id }}" {{ old('category_id', $product->category_id ?? '') == $category->id ? 'selected' : '' }}>{{ $category->name }}</option>
                                                        @endforeach
                                                    </select>
                                                    @if($errors->has('category_id'))
                                                    <p class="text-danger">{{ $errors->first('category_id') }}</p>
                                                    @endif    
                                                </div>
                                            </div>
                                            <div class="col-xxl-3 col-md-6">
                                                <div>
                                                    <label for="subCategorySelect" class="form-label">Sub Category</label>
                                                    <select name="sub_category_id" class="form-select" id="subCategorySelect">
                                                        <option value="">Select Sub Category</option>
                                                        @foreach($subcategories as $subcategory)
                                                            <option value="{{ $subcategory->id }}" {{ old('sub_category_id', $product->sub_category_id ?? '') == $subcategory->id ? 'selected' : '' }}>
                                                                {{ $subcategory->name }}
                                                            </option>
                                                        @endforeach
                                                    
                                                    </select>   
                                                </div>
                                            </div>
                                            <div class="col-xxl-3 col-md-6">
                                                <div>
                                                    <label for="childCategorySelect" class="form-label">Child Category</label>
                                                    <select name="child_category_id" class="form-select" id="childCategorySelect">
                                                        <option value="">Select Child Category</option>
                                                        @foreach($childcategories as $childcategory)
                                                            <option value="{{ $childcategory->id }}" {{ old('child_category_id', $product->child_category_id ?? '') == $childcategory->id ? 'selected' : '' }}>
                                                                {{ $childcategory->name }}
                                                            </option>
                                                        @endforeach     
                                                    </select>   
                                                </div>
                                            </div>
                                            <div class="col-xxl-3 col-md-6">
                                                <div>
                                                    <label for="brandSelect" class="form-label">Brands</label>
                                                    <select name="brand_id" class="form-select" id="brandSelect">
                                                        <option value="">Select Brand</option>
                                                        @foreach($brands as $brand)
                                                            <option value="{{ $brand->id }}" {{ old('brand_id', $product->brand_id ?? '') == $brand->id ? 'selected' : '' }}>{{ $brand->name }}</option>
                                                        @endforeach
                                                    </select>
                                                    @if($errors->has('brand_id'))
                                                    <p class="text-danger">{{ $errors->first('brand_id') }}</p>
                                                    @endif   
                                                </div>
                                            </div>
                                            <!--end col-->
                                            <div class="col-xxl-3 col-md-6">
                                                <div>
                                                    <label for="name" class="form-label">Name</label>
                                                    <input type="text" name="name" class="form-control" id="name" placeholder="Enter Name" value="{{ $product->name }}">
                                                    @if($errors->has('name'))
                                                    <p class="text-danger">{{ $errors->first('name') }}</p>
                                                    @endif 
                                                </div>
                                            </div>
                                            <!--end col-->
                                            <div class="col-xxl-3 col-md-6">
                                                <div>
                                                    <label for="mrp" class="form-label">MRP</label>
                                                    <input type="number" name="mrp" class="form-control" id="placeholderInput" placeholder="Enter MRP" value="{{ $product->mrp }}">
                                                    @if($errors->has('mrp'))
                                                    <p class="text-danger">{{ $errors->first('mrp') }}</p>
                                                    @endif 
                                                </div>
                                            </div>
                                            <!--end col-->
                                            <div class="col-xxl-3 col-md-6">
                                                <div>
                                                    <label for="discount" class="form-label">Discount</label>
                                                    <input type="number" name="discount" class="form-control" step="0.01" id="discount" placeholder="Enter Discount" value="{{ rtrim(rtrim(number_format($product->discount, 2, '.', ''), '0'), '.') }}">
                                                </div>
                                            </div>
                                            <!--end col-->
                                            <div class="col-xxl-3 col-md-6">
                                                <div>
                                                    <label for="selling_price" class="form-label">Selling Price</label>
                                                    <input type="number" name="selling_price" class="form-control" step="0.01" id="selling_price" placeholder="Enter Selling Price" value="{{ rtrim(rtrim(number_format($product->selling_price, 2, '.', ''), '0'), '.') }}">
    
                                                </div>
                                            </div>
                                            <!--end col-->
                                    
                                            <div class="col-xxl-3 col-md-6">
                                                <div>
                                                    <label for="size" class="form-label">Size</label>
                                                    <input type="text" name="size" class="form-control" id="size" placeholder="Enter Size" value="{{ $product->size }}">
                                                    @if($errors->has('size'))
                                                    <p class="text-danger">{{ $errors->first('size') }}</p>
                                                    @endif 
                                                </div>
                                            </div>

                                            <div class="col-xxl-3 col-md-6">
                                                <div>
                                                    <label for="color" class="form-label">Color</label>
                                                    <input type="text" name="color" class="form-control" id="color" placeholder="Enter Color" value="{{ $product->color }}">
                                                    @if($errors->has('color'))
                                                    <p class="text-danger">{{ $errors->first('color') }}</p>
                                                    @endif 
                                                </div>
                                            </div>

                                            <div class="col-xxl-3 col-md-6">
                                                <div>
                                                    <label for="sku" class="form-label">SKU ID</label>
                                                    <input type="text" name="sku" class="form-control" id="sku" placeholder="Enter SKU ID" value="{{ $product->sku }}">
                                                </div>
                                            </div>

                                            <div class="col-xxl-3 col-md-6">
                                                <div>
                                                    <label for="hsn_code" class="form-label">HSN Code</label>
                                                    <input type="number" name="hsn_code" class="form-control" id="hsn_code" placeholder="Enter HSN Code" value="{{ $product->hsn_code }}">
                                                </div>
                                            </div>

                                            <div class="col-xxl-3 col-md-6">
                                                <div>
                                                    <label for="stock" class="form-label">Stock</label>
                                                    <input type="number" name="stock" class="form-control" id="stock" placeholder="Enter Stock" value="{{ $product->stock }}">
                                                    
                                                </div>
                                            </div>

                                            <!-- <input type="hidden" name="product_variant_type_id" id="selected_variant_type_id" value="{{ old('product_variant_type_id', $product->product_variant_type_id) }}">
                                            <div class="dropdown col-xxl-3 col-md-6" style = "margin-top: 50px">
                                                <button class="btn btn btn-light text-dark w-100 dropdown-toggle" type="button" id="variantDropdown" data-bs-toggle="dropdown" aria-expanded="false">
                                                    Select Variant Type
                                                </button>
                                                <ul class="dropdown-menu" aria-labelledby="variantDropdown" id="variant_type_menu">
                                                    @foreach ($variantTypes as $variant)
                                                        <li>
                                                            <a class="dropdown-item variant-option" href="#" data-id="{{ $variant->id }}" data-input-type="{{ $variant->input_type }}">
                                                                {{ $variant->variation_type }}
                                                            </a>
                                                        </li>
                                                    @endforeach
                                                    <li><hr class="dropdown-divider"></li>
                                                    <li class="px-3">
                                                        <input type="text" id="variant_value_input" class="form-control mb-2" placeholder="variant value">
                                                        <button class="btn btn-primary w-100" id="save_variant_value">Save Variant Value</button>
                                                    </li>
                                                </ul>
                                            </div> -->

                                        <div class="row gy-4">
                                            <div class="col-xxl-6 col-md-6">
                                                <div>
                                                    <label for="product_highlights" class="form-label">Product Highlights</label>
                                                    <textarea name="product_highlights" class="form-control ck-editor" id="product_highlights" placeholder="Product Highlights" >{{ $product->product_highlights }}</textarea>
                                                </div>
                                            </div>

                                            <div class="col-xxl-6 col-md-6">
                                                <div>
                                                    <label for="product_description" class="form-label">Product Description</label>
                                                    <textarea name="product_description" class="form-control ck-editor" id="product_description" placeholder="Product Description" >{{ $product->product_description }}</textarea>
                                                </div>
                                            </div>
                                        </div>
                                        <!-- </div> -->

                                            <div class="row gy-4">
                                                
                                                <h4 style="margin-top: 46px">Dimensions</h4>
                                                <div class="col-xxl-3 col-md-6">
                                                    <div>
                                                        <label for="iconInput" class="form-label">Length</label>
                                                        <div class="form-icon">
                                                            <input type="number" step="0.01" name="length" class="form-control form-control-icon" id="iconInput" placeholder="Length (cm)" value="{{ $product->length }}">
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-xxl-3 col-md-6">
                                                    <div>
                                                        <label for="iconInput" class="form-label">Breadth</label>
                                                        <div class="form-icon">
                                                            <input type="number" step="0.01" name="breadth" class="form-control form-control-icon" id="breadth" placeholder="Breadth (cm)" value="{{ $product->breadth }}"> 
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-xxl-3 col-md-6">
                                                    <div>
                                                        <label for="iconInput" class="form-label">Height</label>
                                                        <div class="form-icon">
                                                            <input type="number" step="0.01" name="height" class="form-control form-control-icon" id="height" placeholder="Height (cm)" value="{{ $product->height }}">
                                                            
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-xxl-3 col-md-6">
                                                    <div>
                                                        <label for="iconInput" class="form-label">Weight</label>
                                                        <div class="form-icon">
                                                            <input type="number" step="0.01" name="weight" class="form-control form-control-icon" id="weight" placeholder="Weight (g)" value="{{ $product->weight }}">
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <hr>
                                                <div class="col-xxl-3 col-md-6">
                                                    <div>
                                                        <label for="country_of_origin" class="form-label">Country Of Origin</label>
                                                        <select name="country_of_origin" class="form-select" id="country_of_origin">
                                                            <option value="">Select Country Of Origin</option>
                                                            <option value="India" {{ old('country_of_origin', $product->country_of_origin) == 'India' ? 'selected' : '' }}>India</option>
                                                            <option value="USA" {{ old('country_of_origin', $product->country_of_origin) == 'USA' ? 'selected' : '' }}>USA</option>
                                                               
                                                        </select>  
                                                        @if($errors->has('country_of_origin'))
                                                        <p class="text-danger">{{ $errors->first('country_of_origin') }}</p>
                                                        @endif  
                                                    </div>
                                                </div>

                                                
                                                <div class="col-xxl-3 col-md-6">
                                                <div>
                                                    <label for="manufacturer_details" class="form-label">Manufacturer's Details</label>
                                                    <textarea name="manufacturer_details" class="form-control" id="manufacturer_details" placeholder="Manufacturer's Details">{{ $product->manufacturer_details }}</textarea>
                                                </div>
                                                </div>

                                                <div class="col-xxl-3 col-md-6">
                                                <div>
                                                    <label for="importer_details" class="form-label">Importer's Details</label>
                                                    <textarea name="importer_details" class="form-control" id="importer_details" placeholder="Importer's Details">{{ $product->importer_details }}</textarea>
                                                </div>
                                                </div>

                                                <div class="col-xxl-3 col-md-6">
                                                    <div>
                                                        <label for="packer_details" class="form-label">Packer's Details</label>
                                                        <textarea name="packer_details" class="form-control" id="packer_details" placeholder="Packer's Details">{{ $product->packer_details }}</textarea>
                                                    </div>
                                                </div>



                                                <hr>

                                                <h4>SEO Terms</h4>
                                                <div class="col-xxl-3 col-md-6">
                                                    <div>
                                                        <label for="meta_title" class="form-label">Meta Title</label>
                                                        <div class="form-icon">
                                                            <input type="text" name="meta_title" class="form-control form-control-icon" id="weight" placeholder="Meta Title" value="{{ $product->meta_title }}">
                                                            @if($errors->has('meta_title'))
                                                            <p class="text-danger">{{ $errors->first('meta_title') }}</p>
                                                            @endif 
                                                        </div>
                                                    </div>
                                                </div>

                                                <div class="col-xxl-3 col-md-6">
                                                    <div>
                                                        <label for="meta_description" class="form-label">Meta Description</label>
                                                        <textarea name="meta_description" class="form-control" id="meta_description" placeholder="Meta Description">{{ $product->meta_description }}</textarea>
                                                    </div>
                                                </div>

                                                <div class="col-xxl-3 col-md-6">
                                                    <div>
                                                        <label for="meta_keywords" class="form-label">Meta Keywords</label>
                                                        <textarea name="meta_keywords" class="form-control" id="meta_keywords" placeholder="Meta Keywords">{{ $product->meta_keywords }}</textarea>
                                                    </div>
                                                </div>

                                                <hr>
                                                <div class="col-xxl-3 col-md-6">
                                                    <div>
                                                        <label for="meta_title" class="form-label">Product Tags</label>
                                                        <div class="form-icon">
                                                            <input type="text" name="tags" class="form-control form-control-icon" id="weight" placeholder="Product Tags (comma-separated)" value="{{ $product->tags }}">
                                                        </div>
                                                    </div>
                                                </div>

                                                <div class="col-xxl-3 col-md-6">
                                                    <div>
                                                        <label for="note" class="form-label">Note</label>
                                                        <textarea name="note" class="form-control" id="note" placeholder="Note" value="{{ $product->note }}"></textarea>
                                                    </div>
                                                </div>

                                                <div class="col-xxl-3 col-md-6">
                                                    <div>
                                                        <label for="statusSelect" class="form-label">Status</label>
                                                        <select name="status" class="form-select" id="statusSelect">
                                                            <option value="">Select Status</option>
                                                            <option value="active" {{ old('status', $product->status) == 'active' ? 'selected' : '' }}>Active</option>
                                                            <option value="inactive" {{ old('status', $product->status) == 'inactive' ? 'selected' : '' }}>Inactive</option>
                                                        </select>
                                                        @if($errors->has('status'))
                                                        <p class="text-danger">{{ $errors->first('status') }}</p>
                                                        @endif    
                                                    </div>
                                                </div>

                                                <div class="col-xxl-3 col-md-6">
                                                    <div>
                                                        <label for="featured_image" class="form-label">Featured Image</label>
                                                        <input type="file" name="featured_image" class="form-control" id="featured_image" value="{{ old('featured_image') }}">
                                                        @if($errors->has('featured_image'))
                                                        <p class="text-danger">{{ $errors->first('featured_image') }}</p>
                                                        @endif
                                                    </div>
                                                    @if($product->featured_image)
                                                    <div class="mt-2">
                                                        <img src="{{ asset('uploads/products/' . $product->featured_image) }}" 
                                                            alt="Current Image" width="50">
                                                    </div>
                                                    @endif
                                                </div>

                                                <div class="col-xxl-3 col-md-6">
                                                    <div>
                                                        <label for="bulk_images" class="form-label">Bulk Images</label>
                                                        <input type="file" name="bulk_images[]" class="form-control" id="bulk_images" multiple>
                                                        @if($errors->has('bulk_images'))
                                                        <p class="text-danger">{{ $errors->first('bulk_images') }}</p>
                                                        @endif
                                                    </div>

                                                    @if(!empty($product->bulk_images) && is_array(json_decode($product->bulk_images, true)))
                                                        <div class="mt-2 d-flex flex-wrap gap-2">
                                                            @foreach(json_decode($product->bulk_images) as $image)
                                                                <div style="position: relative; width: 50px;">
                                                                    <img src="{{ asset('uploads/products/' . $image) }}" alt="Bulk Image" width="50">
                                                                </div>
                                                            @endforeach
                                                        </div>
                                                    @endif
                                                </div>
                                                
                                                <div style="text-align: center;">
                                                    <button type="submit" class="btn btn-primary">Submit</button>
                                                </div>
                                            </div>                                            
                            
                                        </div>
                                        <!--end row-->
                                    </div>
                                    
                                </div>
                                </form>
                            </div>
                        </div>
                        <!--end col-->
                    </div>
                    <!--end row-->
                    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
                    <script>
                        const BASE_URL = "{{ env('APP_URL') }}";
                    $(document).ready(function () {
                        $('select[name="category_id"]').on('change', function () {
                            let categoryId = $(this).val();
                            if (categoryId) {
                                $.get(`${BASE_URL}/get-subcategories/${categoryId}`, function (data) {
                                    $('select[name="sub_category_id"]').empty().append('<option value="">-- Select --</option>');
                                    $.each(data, function (id, name) {
                                        $('select[name="sub_category_id"]').append(`<option value="${id}">${name}</option>`);
                                    });
                                    $('select[name="child_category_id"]').empty().append('<option value="">-- Select --</option>');
                                });
                            }
                        });

                        $('select[name="sub_category_id"]').on('change', function () {
                            let subcatId = $(this).val();
                            if (subcatId) {
                                $.get(`${BASE_URL}/get-childcategories/${subcatId}`, function (data) {
                                    $('select[name="child_category_id"]').empty().append('<option value="">-- Select --</option>');
                                    $.each(data, function (id, name) {
                                        $('select[name="child_category_id"]').append(`<option value="${id}">${name}</option>`);
                                    });
                                });
                            }
                        });
                    });
                    </script>

                    <script src="https://cdn.ckeditor.com/ckeditor5/39.0.1/classic/ckeditor.js"></script>
                    <script>
                        document.querySelectorAll('.ck-editor').forEach(editorElement => {
                            ClassicEditor
                                .create(editorElement)
                                .catch(error => {
                                    console.error(error);
                                });
                        });
                    </script>

<!------- for amount calculation  -->

<script>
    document.addEventListener('DOMContentLoaded', function () {
        const mrpInput = document.querySelector('input[name="mrp"]');
        const discountInput = document.querySelector('input[name="discount"]');
        const sellingPriceInput = document.querySelector('input[name="selling_price"]');

        function calculateSellingPrice() {
            const mrp = parseFloat(mrpInput.value);
            const discount = parseFloat(discountInput.value);
            if (!isNaN(mrp) && !isNaN(discount)) {
                const sellingPrice = mrp - (mrp * discount / 100);
                sellingPriceInput.value = sellingPrice.toFixed(2);
            }
        }

        function calculateDiscount() {
            const mrp = parseFloat(mrpInput.value);
            const sellingPrice = parseFloat(sellingPriceInput.value);
            if (!isNaN(mrp) && !isNaN(sellingPrice) && mrp !== 0) {
                const discount = ((mrp - sellingPrice) / mrp) * 100;
                discountInput.value = discount.toFixed(2);
            }
        }

        // Event listeners
        mrpInput.addEventListener('input', function () {
            if (discountInput.value) {
                calculateSellingPrice();
            } else if (sellingPriceInput.value) {
                calculateDiscount();
            }
        });

        discountInput.addEventListener('input', function () {
            if (mrpInput.value) {
                calculateSellingPrice();
            }
        });

        sellingPriceInput.addEventListener('input', function () {
            if (mrpInput.value) {
                calculateDiscount();
            }
        });
    });
</script>

@include('admin.layouts.footer')                   