@include('admin.layouts.header')
@include('admin.layouts.sidebar')
        <!-- ============================================================== -->
        <!-- Start right Content here -->
        <!-- ============================================================== -->
        <div class="main-content">

            <div class="page-content">
                <div class="container-fluid">

                    <!-- start page title -->
                    <div class="row">
                        <div class="col-12">
                            <div class="page-title-box d-sm-flex align-items-center justify-content-between bg-galaxy-transparent">
                                <h4 class="mb-sm-0">Add Products</h4>

                                <div class="page-title-right">
                                    <ol class="breadcrumb m-0">
                                        <li class="breadcrumb-item"><a href="javascript: void(0);">Forms</a></li>
                                        <li class="breadcrumb-item active">Add Products</li>
                                    </ol>
                                </div>

                            </div>
                        </div>
                    </div>
                    <!-- end page title -->

                    <div class="row">
                        <div class="col-lg-12">
                            <div class="card">
                                <div class="card-header align-items-center d-flex">
                                    <h4 class="card-title mb-0 flex-grow-1">Input Example</h4>
                                    
                                </div><!-- end card header -->
                                <form action="{{ route('product.save') }}" method="post" enctype="multipart/form-data">
                                @csrf
                                <div class="card-body">
                                    <div class="live-preview">
                                        <div class="row gy-4">

                                        <!-- add variant values -->
                                             
                                        <!-- <div class="col-12">
                                            <label class="form-label">Product Variant</label>
                                            <div id="addon-wrapper">

                                                    @php
                                                        $oldAddons = old('addons', []);
                                                    @endphp
                                                    @if(count($oldAddons) == 0)
                                                        <div class="row addon-row mb-2">
                                                            <div class="col-md-4">
                                                                <select name="addons[0][type]" class="form-select">
                                                                    <option value="">Select Variant Type</option>
                                                                    @foreach($variantTypes as $type)
                                                                        <option value="{{ $type->id }}">{{ $type->variation_type }}</option>
                                                                    @endforeach
                                                                </select>
                                                            </div>
                                                            <div class="col-md-3">
                                                                <input type="text" name="addons[0][value]" class="form-control" placeholder="Enter Value">
                                                            </div>
                                                            <div class="col-md-3">
                                                                <input type="text" name="addons[0][price]" class="form-control" placeholder="Enter Price">
                                                            </div>
                                                            <div class="col-md-2 d-flex align-items-center">
                                                                <button type="button" class="btn btn-success" onclick="addAddonRow()">+</button>
                                                            </div>
                                                        </div>
                                                    @endif

                                                    

                                                    @foreach($oldAddons as $index => $addon)
                                                    <div class="row addon-row mb-2">
                                                        <div class="col-md-4">
                                                            <select name="addons[{{ $index }}][type]" class="form-select" required>
                                                                <option value="">Select Variant Type</option>
                                                                @foreach($variantTypes as $type)
                                                                    <option value="{{ $type->id }}" {{ $addon['type'] == $type->id ? 'selected' : '' }}>
                                                                        {{ $type->variation_type }}
                                                                    </option>
                                                                @endforeach
                                                            </select>
                                                        </div>
                                                        <div class="col-md-3">
                                                            <input type="text" name="addons[{{ $index }}][value]" class="form-control" value="{{ $addon['value'] ?? '' }}" placeholder="Enter value" required>
                                                        </div>
                                                        <div class="col-md-3">
                                                            <input type="number" step="0.01" name="addons[{{ $index }}][price]" class="form-control" value="{{ $addon['price'] ?? '' }}" placeholder="Enter price" required>
                                                        </div>
                                                        <div class="col-md-2 d-flex align-items-center">
                                                        <button type="button" class="btn btn-success" onclick="addAddonRow()">+</button>
                                                        </div>
                                                    </div>
                                                    @endforeach
                                            </div>
                                        </div> -->

                                            <div class="col-xxl-3 col-md-6">
                                                <div>
                                                    <label for="categorySelect" class="form-label">Category</label>
                                                    <select name="category_id" class="form-select" id="categorySelect">
                                                        <option value="">Select Category</option>
                                                        @foreach($categories as $category)
                                                            <!-- <option value="{{ $category->id }}">{{ $category->name }}</option> -->
                                                            <option value="{{ $category->id }}"
                                                                {{ old('category_id') == $category->id ? 'selected' : '' }}>
                                                                {{ $category->name }}
                                                            </option>
                                                        @endforeach
                                                    </select>
                                                    @if($errors->has('category_id'))
                                                    <p class="text-danger">{{ $errors->first('category_id') }}</p>
                                                    @endif    
                                                </div>
                                            </div>
                                            <div class="col-xxl-3 col-md-6">
                                                <div>
                                                    <label for="subCategorySelect" class="form-label">Sub Category</label>
                                                    <select name="sub_category_id" class="form-select" id="subCategorySelect">
                                                        <option value="">Select Sub Category</option>
                                                        
                                                    </select> 
                                                    @if($errors->has('sub_category_id'))
                                                    <p class="text-danger">{{ $errors->first('sub_category_id') }}</p>
                                                    @endif  
                                                </div>
                                            </div>
                                            <div class="col-xxl-3 col-md-6">
                                                <div>
                                                    <label for="childCategorySelect" class="form-label">Child Category</label>
                                                    <select name="child_category_id" class="form-select" id="childCategorySelect">
                                                        <option value="">Select Child Category</option>    
                                                    </select> 
                                                    @if($errors->has('child_category_id'))
                                                    <p class="text-danger">{{ $errors->first('child_category_id') }}</p>
                                                    @endif  
                                                </div>
                                            </div>
                                            <div class="col-xxl-3 col-md-6">
                                                <div>
                                                    <label for="brandSelect" class="form-label">Brands</label>
                                                    <select name="brand_id" class="form-select" id="brandSelect">
                                                        <option value="">Select Brand</option>
                                                        @foreach($brands as $brand)
                                                            <option value="{{ $brand->id }}"
                                                            {{ old('brand_id') == $brand->id ? 'selected' : '' }}>
                                                                {{ $brand->name }}
                                                            </option>
                                                        @endforeach
                                                    </select>
                                                    @if($errors->has('brand_id'))
                                                    <p class="text-danger">{{ $errors->first('brand_id') }}</p>
                                                    @endif   
                                                </div>
                                            </div>
                                            <!--end col-->
                                            <div class="col-xxl-3 col-md-6">
                                                <div>
                                                    <label for="name" class="form-label">Name</label>
                                                    <input type="text" name="name" class="form-control" id="name" placeholder="Enter Name" value="{{ old('name') }}">
                                                    @if($errors->has('name'))
                                                    <p class="text-danger">{{ $errors->first('name') }}</p>
                                                    @endif 
                                                </div>
                                            </div>
                                            <!--end col-->
                                            <div class="col-xxl-3 col-md-6">
                                                <div>
                                                    <label for="mrp" class="form-label">MRP</label>
                                                    <input type="number" name="mrp" class="form-control" id="placeholderInput" placeholder="Enter MRP" value="{{ old('mrp') }}">
                                                    @if($errors->has('mrp'))
                                                    <p class="text-danger">{{ $errors->first('mrp') }}</p>
                                                    @endif
                                                </div>
                                            </div>
                                            <!--end col-->
                                            <div class="col-xxl-3 col-md-6">
                                                <div>
                                                    <label for="discount" class="form-label">Discount</label>
                                                    <input type="number" name="discount" class="form-control" step="0.01" id="discount" placeholder="Enter Discount" value="{{ old('discount') }}">
                                                    @if($errors->has('discount'))
                                                    <p class="text-danger">{{ $errors->first('discount') }}</p>
                                                    @endif
                                                </div>
                                            </div>
                                            <!--end col-->
                                            <div class="col-xxl-3 col-md-6">
                                                <div>
                                                    <label for="selling_price" class="form-label">Selling Price</label>
                                                    <input type="number" name="selling_price" class="form-control" step="0.01" id="selling_price" placeholder="Enter Selling Price" value="{{ old('selling_price') }}">
                                                    @if($errors->has('selling_price'))
                                                    <p class="text-danger">{{ $errors->first('selling_price') }}</p>
                                                    @endif
                                                </div>
                                            </div>
                                            <!--end col-->
                                    
                                            <div class="col-xxl-3 col-md-6">
                                                <div>
                                                    <label for="size" class="form-label">Size</label>
                                                    <input type="text" name="size" class="form-control" id="size" placeholder="Enter Size" value="{{ old('size') }}">
                                                    @if($errors->has('size'))
                                                    <p class="text-danger">{{ $errors->first('size') }}</p>
                                                    @endif
                                                </div>
                                            </div>

                                            <div class="col-xxl-3 col-md-6">
                                                <div>
                                                    <label for="color" class="form-label">Color</label>
                                                    <input type="text" name="color" class="form-control" id="color" placeholder="Enter Color" value="{{ old('color') }}">
                                                    @if($errors->has('color'))
                                                    <p class="text-danger">{{ $errors->first('color') }}</p>
                                                    @endif
                                                </div>
                                            </div>

                                            <div class="col-xxl-3 col-md-6">
                                                <div>
                                                    <label for="sku" class="form-label">SKU ID</label>
                                                    <input type="text" name="sku" class="form-control" id="sku" placeholder="Enter SKU ID" value="{{ old('sku') }}">
                                                    @if($errors->has('sku'))
                                                    <p class="text-danger">{{ $errors->first('sku') }}</p>
                                                    @endif
                                                </div>
                                            </div>

                                            <div class="col-xxl-3 col-md-6">
                                                <div>
                                                    <label for="hsn_code" class="form-label">HSN Code</label>
                                                    <input type="number" name="hsn_code" class="form-control" id="hsn_code" placeholder="Enter HSN Code" value="{{ old('hsn_code') }}">
                                                    @if($errors->has('hsn_code'))
                                                    <p class="text-danger">{{ $errors->first('hsn_code') }}</p>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="col-xxl-3 col-md-6">
                                                <div>
                                                    <label for="stock" class="form-label">Stock</label>
                                                    <input type="number" name="stock" class="form-control" id="stock" placeholder="Enter Stock" value="{{ old('stock') }}">
                                                    @if($errors->has('stock'))
                                                    <p class="text-danger">{{ $errors->first('stock') }}</p>
                                                    @endif
                                                </div>
                                            </div>


                                            <!-- add variant type -->
                                            <!-- <input type="hidden" name="product_variant_type_id" id="selected_variant_type_id" value="{{ old('product_variant_type_id') }}">
                                            <div class="dropdown col-xxl-3 col-md-6" style = "margin-top: 50px">
                                                <button class="btn btn btn-light text-dark w-100 dropdown-toggle" type="button" id="variantDropdown" data-bs-toggle="dropdown" aria-expanded="false">
                                                    Select Variant Type
                                                </button>
                                                <ul class="dropdown-menu" aria-labelledby="variantDropdown" id="variant_type_menu">
                                                    @foreach ($variantTypes as $variant)
                                                        <li>
                                                            <a class="dropdown-item variant-option" href="#" data-id="{{ $variant->id }}" data-input-type="{{ $variant->input_type }}">
                                                                {{ $variant->variation_type }}
                                                            </a>
                                                        </li>
                                                    @endforeach
                                                    <li><hr class="dropdown-divider"></li>
                                                    <li class="px-3">
                                                        <input type="text" id="variant_value_input" class="form-control mb-2" placeholder="variant value">
                                                        <button class="btn btn-primary w-100" id="save_variant_value">Save Variant Value</button>
                                                    </li>
                                                </ul>
                                                @if($errors->has('product_variant_type_id'))
                                                <p class="text-danger">{{ $errors->first('product_variant_type_id') }}</p>
                                            @endif
                                            </div> -->
                                            

                                        <div class="row gy-4">
                                            <div class="col-xxl-6 col-md-6">
                                                <div>
                                                    <label for="product_highlights" class="form-label">Product Highlights</label>
                                                    <input name="product_highlights" class="form-control ck-editor" id="product_highlights" placeholder="Product Highlights" value="{{ old('product_highlights') }}">
                                                    @if($errors->has('product_highlights'))
                                                    <p class="text-danger">{{ $errors->first('product_highlights') }}</p>
                                                    @endif
                                                </div>
                                            </div>

                                            <div class="col-xxl-6 col-md-6">
                                                <div>
                                                    <label for="product_description" class="form-label">Product Description</label>
                                                    <input name="product_description" class="form-control ck-editor" id="product_description" placeholder="Product Description" value="{{ old('product_description') }}">
                                                    @if($errors->has('product_description'))
                                                    <p class="text-danger">{{ $errors->first('product_description') }}</p>
                                                    @endif
                                                </div>
                                            </div>
                                        </div>
                                        <!-- </div> -->

                                            <div class="row gy-4">
                                                
                                                <h4 style="margin-top: 46px">Dimensions</h4>
                                                <div class="col-xxl-3 col-md-6">
                                                    <div>
                                                        <label for="iconInput" class="form-label">Length</label>
                                                        <div class="form-icon">
                                                            <input type="number" step="0.01" name="length" class="form-control form-control-icon" id="iconInput" placeholder="Length (cm)" value="{{ old('length') }}">
                                                            @if($errors->has('length'))
                                                            <p class="text-danger">{{ $errors->first('length') }}</p>
                                                            @endif
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-xxl-3 col-md-6">
                                                    <div>
                                                        <label for="iconInput" class="form-label">Breadth</label>
                                                        <div class="form-icon">
                                                            <input type="number" step="0.01" name="breadth" class="form-control form-control-icon" id="breadth" placeholder="Breadth (cm)" value="{{ old('breadth') }}">
                                                            @if($errors->has('breadth'))
                                                            <p class="text-danger">{{ $errors->first('breadth') }}</p>
                                                            @endif 
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-xxl-3 col-md-6">
                                                    <div>
                                                        <label for="iconInput" class="form-label">Height</label>
                                                        <div class="form-icon">
                                                            <input type="number" step="0.01" name="height" class="form-control form-control-icon" id="height" placeholder="Height (cm)" value="{{ old('height') }}">
                                                            @if($errors->has('height'))
                                                            <p class="text-danger">{{ $errors->first('height') }}</p>
                                                            @endif
                                                            
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-xxl-3 col-md-6">
                                                    <div>
                                                        <label for="iconInput" class="form-label">Weight</label>
                                                        <div class="form-icon">
                                                            <input type="number" step="0.01" name="weight" class="form-control form-control-icon" id="weight" placeholder="Weight (g)" value="{{ old('weight') }}">
                                                            @if($errors->has('weight'))
                                                            <p class="text-danger">{{ $errors->first('weight') }}</p>
                                                            @endif
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <hr>
                                                <div class="col-xxl-3 col-md-6">
                                                    <div>
                                                        <label for="country_of_origin" class="form-label">Country Of Origin</label>
                                                        <select name="country_of_origin" class="form-select" id="country_of_origin">
                                                            <option value="">Select Country Of Origin</option>
                                                            <option value="India" {{ old('country_of_origin') == 'India' ? 'selected' : '' }}>India</option>
                                                            <option value="USA" {{ old('country_of_origin') == 'USA' ? 'selected' : '' }}>USA</option>    
                                                        </select> 
                                                        @if($errors->has('country_of_origin'))
                                                            <p class="text-danger">{{ $errors->first('country_of_origin') }}</p>
                                                        @endif  
                                                    </div>
                                                </div>

                                                
                                                <div class="col-xxl-3 col-md-6">
                                                <div>
                                                    <label for="manufacturer_details" class="form-label">Manufacturer's Details</label>
                                                    <textarea name="manufacturer_details" class="form-control" id="manufacturer_details" placeholder="Manufacturer's Details">{{ old('manufacturer_details') }}</textarea>
                                                    @if($errors->has('manufacturer_details'))
                                                        <p class="text-danger">{{ $errors->first('manufacturer_details') }}</p>
                                                    @endif 
                                                </div>
                                                </div>

                                                <div class="col-xxl-3 col-md-6">
                                                <div>
                                                    <label for="importer_details" class="form-label">Importer's Details</label>
                                                    <textarea name="importer_details" class="form-control" id="importer_details" placeholder="Importer's Details">{{ old('importer_details') }}</textarea>
                                                    @if($errors->has('importer_details'))
                                                        <p class="text-danger">{{ $errors->first('importer_details') }}</p>
                                                    @endif 
                                                </div>
                                                </div>

                                                <div class="col-xxl-3 col-md-6">
                                                    <div>
                                                        <label for="packer_details" class="form-label">Packer's Details</label>
                                                        <textarea name="packer_details" class="form-control" id="packer_details" placeholder="Packer's Details">{{ old('packer_details') }}</textarea>
                                                        @if($errors->has('packer_details'))
                                                            <p class="text-danger">{{ $errors->first('packer_details') }}</p>
                                                        @endif 
                                                    </div>
                                                </div>



                                                <hr>

                                                <h4>SEO Terms</h4>
                                                <div class="col-xxl-3 col-md-6">
                                                    <div>
                                                        <label for="meta_title" class="form-label">Meta Title</label>
                                                        <div class="form-icon">
                                                            <input type="text" name="meta_title" class="form-control form-control-icon" id="weight" placeholder="Meta Title" value="{{ old('meta_title') }}">
                                                            @if($errors->has('meta_title'))
                                                            <p class="text-danger">{{ $errors->first('meta_title') }}</p>
                                                            @endif
                                                        </div>
                                                    </div>
                                                </div>

                                                <div class="col-xxl-3 col-md-6">
                                                    <div>
                                                        <label for="meta_description" class="form-label">Meta Description</label>
                                                        <textarea name="meta_description" class="form-control" id="meta_description" placeholder="Meta Description">{{ old('meta_description') }}</textarea>
                                                        @if($errors->has('meta_description'))
                                                            <p class="text-danger">{{ $errors->first('meta_description') }}</p>
                                                        @endif
                                                    </div>
                                                </div>

                                                <div class="col-xxl-3 col-md-6">
                                                    <div>
                                                        <label for="meta_keywords" class="form-label">Meta Keywords</label>
                                                        <textarea name="meta_keywords" class="form-control" id="meta_keywords" placeholder="Meta Keywords">{{ old('meta_keywords') }}</textarea>
                                                        @if($errors->has('meta_keywords'))
                                                            <p class="text-danger">{{ $errors->first('meta_keywords') }}</p>
                                                        @endif
                                                    </div>
                                                </div>

                                                <hr>
                                                <div class="col-xxl-3 col-md-6">
                                                    <div>
                                                        <label for="meta_title" class="form-label">Product Tags</label>
                                                        <div class="form-icon">
                                                            <input type="text" name="tags" class="form-control form-control-icon" id="weight" placeholder="Product Tags (comma-separated)" value="{{ old('tags') }}">
                                                            @if($errors->has('tags'))
                                                            <p class="text-danger">{{ $errors->first('tags') }}</p>
                                                            @endif
                                                        </div>
                                                    </div>
                                                </div>

                                                <div class="col-xxl-3 col-md-6">
                                                    <div>
                                                        <label for="note" class="form-label">Note</label>
                                                        <textarea name="note" class="form-control" id="note" placeholder="Note">{{ old('note') }}</textarea>
                                                        @if($errors->has('note'))
                                                            <p class="text-danger">{{ $errors->first('note') }}</p>
                                                        @endif
                                                    </div>
                                                </div>

                                                <div class="col-xxl-3 col-md-6">
                                                    <div>
                                                        <label for="statusSelect" class="form-label">Status</label>
                                                        <select name="status" class="form-select" id="statusSelect">
                                                            <option value="">Select Status</option>
                                                            <option value="active" {{ old('status') == 'active' ? 'selected' : '' }}>Active</option>
                                                            <option value="inactive" {{ old('status') == 'inactive' ? 'selected' : '' }}>Inactive</option>
                                                        </select> 
                                                        @if($errors->has('status'))
                                                            <p class="text-danger">{{ $errors->first('status') }}</p>
                                                        @endif  
                                                    </div>
                                                </div>

                                                <div class="col-xxl-3 col-md-6">
                                                    <div>
                                                        <label for="featured_image" class="form-label">Featured Image</label>
                                                        <input type="file" name="featured_image" class="form-control" id="featured_image" value="{{ old('featured_image') }}">
                                                        @if($errors->has('featured_image'))
                                                            <p class="text-danger">{{ $errors->first('featured_image') }}</p>
                                                        @endif  
                                                    </div>
                                                </div>

                                                <div class="col-xxl-3 col-md-6">
                                                    <div>
                                                        <label for="bulk_images" class="form-label">Bulk Images</label>
                                                        <input type="file" name="bulk_images[]" class="form-control" id="bulk_images" multiple>
                                                        @if($errors->has('bulk_images'))
                                                            <p class="text-danger">{{ $errors->first('bulk_images') }}</p>
                                                        @endif 
                                                    </div>
                                                </div>
                                                
                                                <div style="text-align: center;">
                                                    <button type="submit" class="btn btn-primary">Submit</button>
                                                </div>
                                            </div>                                            
                            
                                        </div>
                                        <!--end row-->
                                    </div>
                                    
                                </div>
                                </form>
                            </div>
                        </div>
                        <!--end col-->
                    </div>
                    <!--end row-->
                    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
                    <script>
                        const BASE_URL = "{{ env('APP_URL') }}";
                    $(document).ready(function () {
                        $('select[name="category_id"]').on('change', function () {
                            let categoryId = $(this).val();
                            if (categoryId) {
                                $.get(`${BASE_URL}/get-subcategories/${categoryId}`, function (data) {
                                    $('select[name="sub_category_id"]').empty().append('<option value="">-- Select --</option>');
                                    $.each(data, function (id, name) {
                                        $('select[name="sub_category_id"]').append(`<option value="${id}">${name}</option>`);
                                    });
                                    $('select[name="child_category_id"]').empty().append('<option value="">-- Select --</option>');
                                });
                            }
                        });

                        $('select[name="sub_category_id"]').on('change', function () {
                            let subcatId = $(this).val();
                            if (subcatId) {
                                $.get(`${BASE_URL}/get-childcategories/${subcatId}`, function (data) {
                                    $('select[name="child_category_id"]').empty().append('<option value="">-- Select --</option>');
                                    $.each(data, function (id, name) {
                                        $('select[name="child_category_id"]').append(`<option value="${id}">${name}</option>`);
                                    });
                                });
                            }
                        });
                    });
                    </script>

                    <script src="https://cdn.ckeditor.com/ckeditor5/39.0.1/classic/ckeditor.js"></script>
                    <script>
                        document.querySelectorAll('.ck-editor').forEach(editorElement => {
                            ClassicEditor
                                .create(editorElement)
                                .catch(error => {
                                    console.error(error);
                                });
                        });
                    </script>

<!------- for amount calculation  -->
<script>
    document.addEventListener('DOMContentLoaded', function () {
        const mrpInput = document.querySelector('input[name="mrp"]');
        const discountInput = document.querySelector('input[name="discount"]');
        const sellingPriceInput = document.querySelector('input[name="selling_price"]');

        function calculateSellingPrice() {
            const mrp = parseFloat(mrpInput.value);
            const discount = parseFloat(discountInput.value);
            if (!isNaN(mrp) && !isNaN(discount)) {
                const sellingPrice = mrp - (mrp * discount / 100);
                sellingPriceInput.value = sellingPrice.toFixed(2);
            }
        }

        function calculateDiscount() {
            const mrp = parseFloat(mrpInput.value);
            const sellingPrice = parseFloat(sellingPriceInput.value);
            if (!isNaN(mrp) && !isNaN(sellingPrice) && mrp !== 0) {
                const discount = ((mrp - sellingPrice) / mrp) * 100;
                discountInput.value = discount.toFixed(2);
            }
        }

        // Event listeners
        mrpInput.addEventListener('input', function () {
            if (discountInput.value) {
                calculateSellingPrice();
            } else if (sellingPriceInput.value) {
                calculateDiscount();
            }
        });

        discountInput.addEventListener('input', function () {
            if (mrpInput.value) {
                calculateSellingPrice();
            }
        });

        sellingPriceInput.addEventListener('input', function () {
            if (mrpInput.value) {
                calculateDiscount();
            }
        });
    });
</script>


<!-- <script>
    $(document).ready(function () {
        // Restore old selected variant type on load
        let oldVariantId = $('#selected_variant_type_id').val();
        if (oldVariantId) {
            let selectedOption = $('.variant-option[data-id="' + oldVariantId + '"]');
            if (selectedOption.length) {
                $('#variantDropdown').text(selectedOption.text());
                $('.variant-option').removeClass('active');
                selectedOption.addClass('active');
            }
        }

        // Handle variant selection
        $('.variant-option').on('click', function (e) {
            e.preventDefault();

            let variantId = $(this).data('id');
            let variantText = $(this).text();

            $('#variantDropdown').text(variantText); // update button
            $('#selected_variant_type_id').val(variantId); // update hidden input

            $('.variant-option').removeClass('active');
            $(this).addClass('active');
        });

        // Handle save variant value via AJAX
        $('#save_variant_value').on('click', function (e) {
            e.preventDefault();

            let value = $('#variant_value_input').val();
            let variantTypeId = $('#selected_variant_type_id').val();

            if (!variantTypeId || !value) {
                alert('Please select variant type and enter a value.');
                return;
            }

            // Set CSRF for AJAX
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $.ajax({
                url: "{{ route('variant.value.store') }}",
                type: "POST",
                data: {
                    product_variant_type_id: variantTypeId,
                    name: value
                },
                success: function (response) {
                    if (response.status === 'true') {
                        alert('Variant value saved successfully!');
                        $('#variant_value_input').val('');
                    } else {
                        alert('Error: ' + response.message);
                    }
                },
                error: function (xhr) {
                    console.error(xhr.responseText);
                    alert('AJAX error occurred. Check console.');
                }
            });
        });
    });
</script> -->

<!-- 
<script>
    let addonIndex = 1;

    function addAddonRow() {
        const wrapper = document.getElementById('addon-wrapper');


        const lastRow = wrapper.querySelector('.addon-row:last-child');

        // Get values from the last row
        const type = lastRow.querySelector('select').value;
        const value = lastRow.querySelector('input[name^="addons"][name$="[value]"]').value.trim();
        const price = lastRow.querySelector('input[name^="addons"][name$="[price]"]').value.trim();

        // Check if any field is empty
        if (!type || !value || !price) {
            alert('Please fill in all fields before adding another row.');
            return;
        }


        const newRow = document.createElement('div');
        newRow.classList.add('row', 'addon-row', 'mb-2');


        newRow.innerHTML = `
            <div class="col-md-4">
                <select name="addons[${addonIndex}][type]" class="form-select">
                    <option value="">Select Addon Type</option>
                    @foreach($variantTypes as $type)
                        <option value="{{ $type->id }}">{{ $type->variation_type }}</option>
                    @endforeach
                </select>
            </div>
            <div class="col-md-3">
                <input type="text" name="addons[${addonIndex}][value]" class="form-control" placeholder="Enter Value">
            </div>
            <div class="col-md-3">
                <input type="text" name="addons[${addonIndex}][price]" class="form-control" placeholder="Enter Price">
            </div>
            <div class="col-md-2 d-flex align-items-center">
                <button type="button" class="btn btn-danger" onclick="this.closest('.addon-row').remove()">−</button>
            </div>
        `;

        wrapper.appendChild(newRow);
        addonIndex++;
    }
</script> -->

@include('admin.layouts.footer')                   