@include('admin.layouts.header')
@include('admin.layouts.sidebar') 


<link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css">                 
        <!-- Vertical Overlay-->
        <div class="vertical-overlay"></div>
        <div class="main-content">

            <div class="page-content">
                <div class="container-fluid">
                    <div class="row">
                        <div class="col-12">
                            <div class="page-title-box d-sm-flex align-items-center justify-content-between bg-galaxy-transparent">
                                <h4 class="mb-sm-0">Product Attribute List</h4>

                                <div class="page-title-right">
                                    <ol class="breadcrumb m-0">
                                        <li class="breadcrumb-item"><a href="javascript: void(0);">Tables</a></li>
                                        <li class="breadcrumb-item active">Product Attribute List</li>
                                    </ol>
                                </div>

                            </div>
                        </div>
                    </div>
                    <!-- end page title -->

                    <div class="row">
                    
                        <div class="col-xl-12">
                            <div class="card">
                                <div class="card-header align-items-center d-flex">
                                    <h4 class="card-title mb-0 flex-grow-1">Product Attribute List</h4>
                                    <div class="d-flex justify-content-end">
                                    <a href="{{ route('attribute.value.add') }}">
                                    <button type="button" class="btn btn-primary d-flex justify-content-end">Add Product Attribute</button>
                                    </a>
                                </div>
                                </div><!-- end card header -->

                                <div class="card-body">
                                    
                                    <div class="live-preview">
                                        <div class="table-responsive">
                                            <table id="example" class="table table-striped table-nowrap align-middle mb-0">
                                                <thead>
                                                    <tr>
                                                        <th scope="col">ID</th>
                                                        <th scope="col">Attribute</th>
                                                        <th scope="col">Value</th>
                                                        <th scope="col">Action</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                @if($attribute == "" && $attribute->isEmpty())
                                                <tr>
                                                   <td colspan="5" class="text-center">No data found.</td>
                                                </tr>
                                                @else
                                                @foreach($attribute as $key => $item)
                                                    <tr>
                                                        <td class="fw-medium">{{ $key + 1 }}</td>   
                                                        <td>{{ ucwords($item->attribute->name ?? '')}}</td>
                                                        <td>{{ ucwords($item->value ?? '')}}</td>
                                                        <td><div class="hstack gap-3 flex-wrap">
                                                            <a href="{{ route('attribute.value.edit', $item->id) }}" class="link-success fs-15"><i class="ri-edit-2-line"></i></a>
                                                            <a href="javascript:void(0);" 
                                                            class="link-danger fs-15 delete-category" 
                                                            data-id="{{ $item->id }}">
                                                            <i class="ri-delete-bin-line"></i>
                                                            </a>
                                                            <!-- <a href="{{ route('category.delete', $item->id) }}"  class="link-danger fs-15"><i class="ri-delete-bin-line"></i></a> -->
                                                        </div></td>
                                                    </tr>
                                                @endforeach    
                                                @endif       
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                    
                                </div><!-- end card-body -->
                            </div><!-- end card -->
                        </div>
                        <!-- end col -->
                    </div>
                </div>
            </div>
            <!-- End Page-content -->
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
document.addEventListener('DOMContentLoaded', function () {
    const deleteButtons = document.querySelectorAll('.delete-category');

    deleteButtons.forEach(button => {
        button.addEventListener('click', function () {
            const categoryId = this.getAttribute('data-id');
            Swal.fire({
                title: 'Are you sure?',
                text: "Deleting this product variant type .",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, delete it!'
            }).then((result) => {
                if (result.isConfirmed) {
                    let deleteUrl = "{{ route('attribute.value.delete', ':id') }}".replace(':id', categoryId);
                    window.location.href = deleteUrl;
                }
            });
        });
    });
});
</script>

@include('admin.layouts.footer')  
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
<script>
    $(document).ready(function () {
        $('#example').DataTable({
        responsive: true
        });
    });
</script>


