@include('admin.layouts.header')
@include('admin.layouts.sidebar')

<div class="main-content">

    <div class="page-content">
        <div class="container-fluid">

            <div class="card">
                <div class="card-header">
                    <h4>Order Details: {{ $order->order_id }}</h4>
                </div>

                <div class="card-body">
                    <table class="table table-bordered">
                        <tr>
                            <th>Order ID</th>
                            <td>{{ $order->order_id }}</td>
                        </tr>
                        <tr>
                            <th>Product Name</th>
                            <td>{{ $order->product->name ?? ''}}</td>
                        </tr>
                        <tr>
                            <th>Status</th>
                            <td>{{ $order->order_status }}</td>
                        </tr>
                        <tr>
                            <th>Total Amount</th>
                            <td>₹{{ number_format($order->total, 2) }}</td>
                        </tr>
                        <tr>
                            <th>Order Date</th>
                            <td>{{ $order->created_at->format('d M Y, h:i A') }}</td>
                        </tr>
                        
                        {{-- Add more fields as needed --}}
                    </table>

                    <a href="{{ route('order.list') }}" class="btn btn-secondary mt-3">Back to Orders</a>
                </div>
            </div>

</div>

</div>
    </div>

</div>



@include('admin.layouts.footer')