<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('products', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('category_id');
            $table->unsignedBigInteger('subcategory_id');
            $table->unsignedBigInteger('childcategory_id')->nullable();
            $table->unsignedBigInteger('brand_id')->nullable();
            
            $table->string('name');
            $table->string('slug')->unique();
            $table->decimal('mrp', 10, 2);
            $table->decimal('selling_price', 10, 2);
            $table->integer('discount')->nullable();
        
            $table->string('size')->nullable();
            $table->string('color')->nullable();
            $table->string('sku')->unique();
            $table->string('hsn_code')->nullable();
            
            $table->text('product_highlights')->nullable();
            $table->longText('product_description')->nullable();
            
            $table->decimal('length', 8, 2)->nullable();
            $table->decimal('breadth', 8, 2)->nullable();
            $table->decimal('height', 8, 2)->nullable();
            $table->decimal('weight', 8, 2)->nullable();
        
            $table->string('country_of_origin')->nullable();
            $table->text('manufacturer_details')->nullable();
            $table->text('importer_details')->nullable();
            $table->text('packer_details')->nullable();
        
            $table->string('meta_title')->nullable();
            $table->text('meta_description')->nullable();
            $table->text('meta_keywords')->nullable();
        
            $table->string('tags')->nullable();
            $table->text('note')->nullable();
            $table->boolean('status')->default(true);
            $table->string('featured_image')->nullable();
            $table->json('bulk_images')->nullable();
        
            $table->timestamps();
        });
        
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('products');
    }
};
