<?php

namespace App\Models\AdminModels;

use Illuminate\Database\Eloquent\Model;

class SubCategory extends Model
{
    protected $fillable = [
        'name',
        'category_id',
        'status',
        'meta_title',
        'meta_keywords',
        'meta_description'
    ];

    public function category(){
        return $this->belongsTo(Category::class, 'category_id', 'id');
    }
    public function child_category(){
        return $this->hasMany(ChildCategory::class, 'sub_category_id', 'id');
    }
}
