<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class ProductRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return false;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules()
{
    return [
        // Category selections
        'category_id' => 'required|exists:categories,id',
        'sub_category_id' => 'nullable|exists:sub_categories,id',
        'child_category_id' => 'nullable|exists:child_categories,id',
        'brand_id' => 'nullable|exists:brands,id',

        // Basic product info
        'name' => 'required|string|max:255',
        'mrp' => 'required|numeric|min:0',
        'selling_price' => 'required|numeric|min:0|lte:mrp',
        'discount' => 'nullable|numeric|min:0|max:100',

        'size' => 'nullable|string|max:100',
        'color' => 'nullable|string|max:100',
        'sku' => 'nullable|string|max:100|unique:products,sku',
        'hsn_code' => 'nullable|string|max:50',
        'product_highlights' => 'nullable|string',
        'product_description' => 'nullable|string',

        // Dimensions
        'length' => 'nullable|numeric|min:0',
        'breadth' => 'nullable|numeric|min:0',
        'height' => 'nullable|numeric|min:0',
        'weight' => 'nullable|numeric|min:0',

        // Legal info
        'country_of_origin' => 'nullable|string|max:100',
        'manufacturer_details' => 'nullable|string',
        'importer_details' => 'nullable|string',
        'packer_details' => 'nullable|string',

        // SEO meta
        'meta_title' => 'nullable|string|max:255',
        'meta_description' => 'nullable|string',
        'meta_keywords' => 'nullable|string',

        'tags' => 'nullable|string',
        'note' => 'nullable|string',
        'status' => 'required|in:active,inactive',

        // Images
        'featured_image' => 'nullable|image|mimes:jpeg,png,jpg,gif,svg|max:2048',
        'bulk_images' => 'nullable|array',
        'bulk_images.*' => 'image|mimes:jpeg,png,jpg,gif,svg|max:2048',
    ];
}

}
