<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\AdminModels\Category;
use App\Models\AdminModels\Product;
use Illuminate\Support\Facades\Auth;
use App\Models\Cart;
use App\Models\User;
use App\Models\WebSetting;
use Illuminate\Support\Facades\Session;
use App\Models\AdminModels\Brand;

class HomeController
{

    public function about(){
        return view('about');
    }

    public function productDetails(){
        return view('product-details');
    }

    public function shop(Request $request, $slug, $sub_cat = null, $child_cat = null){
         $category = Category::where('slug', $slug)->with([
            'sub_category' => function($q) use($sub_cat){
             $q->select('id','name','category_id','slug','image')->where('slug', $sub_cat);
        },
            'sub_category.child_category'=> function($q) use($child_cat){
             $q->select('id','name','sub_category_id','slug','image')->where('slug', $child_cat);
        } 
        ])->first();

        return view('shop', compact('category'));
    }

    public function blogs(){
        return view('blogs');
    }
    
    public function newArrivals(Request $request, $slug, $sub_cat = null, $child_cat = null){

        $category = Category::where('slug', $slug)->with([
            'sub_category' => function($q) use($sub_cat){
             $q->select('id','name','category_id','slug','image')->where('slug', $sub_cat);
        },
            'sub_category.child_category'=> function($q) use($child_cat){
             $q->select('id','name','sub_category_id','slug','image')->where('slug', $child_cat);
        } 
        ])->first();

        $query = Product::select('id','slug','category_id','sub_category_id','child_category_id','name','product_id', 'sub_sku' , 'brand_id', 'mrp','selling_price','bulk_images','featured_image','color', 'size')->where('category_id', $category->id);

        if ($sub_cat && $child_cat) {
            // echo "child_cat_slug";
            $childCategoryId = $category->sub_category[0]->child_category[0]->id;
            $query->where('child_category_id', $childCategoryId);
        } elseif ($sub_cat && !$child_cat) {
            // echo "sub_category_id";
            $subCategoryId = $category->sub_category[0]->id;
            $query->where('sub_category_id', $subCategoryId);
        }
        
        if(isset($request->color)){
                $colors = explode(',', $request->color);
                $query->whereIn('color', $colors);
            }
            if(isset($request->size)){
                $size = explode(',', $request->size);
                $query->whereIn('size', $size);
            }

            if(isset($request->brand)){
                $brand = explode(',', $request->brand);
                $query->whereIn('brand_id', $brand);
            }

            if (isset($request->min_price, $request->max_price) && !empty($request->min_price) && !empty($request->max_price)) {
                $query->whereBetween('mrp', [$request->min_price, $request->max_price]);
            }

            if(isset($request->sort)){

                if($request->sort == 'low_high'){
                $query->orderBy('mrp', 'ASC');
                }
                elseif($request->sort == 'high_low'){
                $query->orderBy('mrp', 'DESC');
                }
                elseif($request->sort == 'old_new'){
                $query->orderBy('created_at', 'ASC');
                }
                elseif($request->sort == 'new_old'){
                $query->orderBy('created_at', 'DESC');
                }
                
            }    
           
        $max_price = $query->max('mrp') ?? 0;
        $min_price = $query->min('mrp') ?? 0;  
        $product = $query->paginate(10);
       
 
        $colors = Product::where('category_id', $category->id)
        ->pluck('color')
        ->map(function ($color) {
            return strtolower($color);
        })
        ->unique()
        ->values()
        ->all();
        $sizes = Product::where('category_id', $category->id)->pluck('size')->unique()->values()->all();
        $brand_id = Product::where('category_id', $category->id)->pluck('brand_id')->unique();
        $brands = Brand::select('id', 'name')->whereIn('id', $brand_id)->get();

        return view('new-arrivals', compact('category', 'product', 'colors', 'sizes', 'brands', 'max_price', 'min_price'));
    }

    public function searchProducts(Request $request){

        $keyword = $request->keyword;
        $query = Product::select('id','slug','category_id','sub_category_id','child_category_id','name','product_id', 'sub_sku' , 'brand_id', 'mrp','selling_price','bulk_images','featured_image','color', 'size')
        ->with('category:id,slug')
        ->where(function ($q) use ($keyword) {
            $q->where('name', 'like', "%{$keyword}%")
            ->orWhere('tags', 'like', "%{$keyword}%");
        });

        if(isset($request->color)){
                $colors = explode(',', $request->color);
                $query->whereIn('color', $colors);
            }
            if(isset($request->size)){
                $size = explode(',', $request->size);
                $query->whereIn('size', $size);
            }

            if(isset($request->brand)){
                $brand = explode(',', $request->brand);
                $query->whereIn('brand_id', $brand);
            }

            if (isset($request->min_price, $request->max_price) && !empty($request->min_price) && !empty($request->max_price)) {
                $query->whereBetween('mrp', [$request->min_price, $request->max_price]);
            }

            if(isset($request->sort)){

                if($request->sort == 'low_high'){
                $query->orderBy('mrp', 'ASC');
                }
                elseif($request->sort == 'high_low'){
                $query->orderBy('mrp', 'DESC');
                }
                elseif($request->sort == 'old_new'){
                $query->orderBy('created_at', 'ASC');
                }
                elseif($request->sort == 'new_old'){
                $query->orderBy('created_at', 'DESC');
                }
                
            }    
           
        $max_price = $query->max('mrp') ?? 0;
        $min_price = $query->min('mrp') ?? 0;  
        $product = $query->get();
       
 
        $colors = Product::where('name', 'Like', "%{$keyword}%")->orWhere('tags', 'Like', "%{$keyword}%")
        ->pluck('color')
        ->map(function ($color) {
            return strtolower($color);
        })
        ->unique()
        ->values()
        ->all();
        $sizes = Product::where('name', 'Like', "%{$keyword}%")->orWhere('tags', 'Like', "%{$keyword}%")->pluck('size')->unique()->values()->all();
        $brand_id = Product::where('name', 'Like', "%{$keyword}%")->orWhere('tags', 'Like', "%{$keyword}%")->pluck('brand_id')->unique();
        $brands = Brand::select('id', 'name')->whereIn('id', $brand_id)->get();
        // dd($product);
        return view('search-products', compact('product', 'colors', 'sizes', 'brands', 'max_price', 'min_price'));
    }

    public function contact(){
        return view('contact-us');
    }

    public function faq(){
        return view('faq');
    }

    public function termsConditions(){
        return view('terms-&-conditions');
    }

    public function shippingPolicy(){
        return view('shipping-policy');
    }

    public function refundPolicy(){
        return view('refund-policy');
    }

    public function sitemap(){
        return view('sitemap');
    }

    public function termsofuse(){
        return view('termsofuse');
    }

    public function privacyPolicy(){
        return view('privacy-policy');
    }

    public function product(Request $request, $slug){
        $category = $request->category;
        $cate = Category::where('slug', $category)->first();    
        $products = Product::where('slug', $slug)->where('sub_sku', $request->sub_sku)->get();
        $product_detail = Product::where('slug', $slug)->where('product_id', $request->product_id)->first();

        $colorProducts = $products->unique('color');
        $sizeProducts = $products->unique('size');
        $sizes = $products->pluck('size')->unique()->values();
        $colors = $products->pluck('color')
        ->map(function ($color) {
            return strtolower($color);
        })
        ->unique()
        ->values()
        ->all();
        // dd($sizes);
        $related_product = Product::select('id','category_id','name','featured_image','mrp','selling_price')->where('category_id', $cate->id)->take(6)->get();
        return view('product', compact('category','slug','products','related_product', 'sizes', 'colors', 'colorProducts','sizeProducts', 'product_detail'));
    }

    public function getProductsBySize(Request $request)
    {
        $slug = $request->slug;
        $subSku = $request->sub_sku;
        $size = $request->size;

        $query = Product::where('slug', $slug)->where('sub_sku', $subSku);

        if ($size) {
            $query->where('size', $size);
        }

        $products = $query->get();

        $colors = $products->pluck('color')
            ->map(fn($color) => strtolower($color))
            ->unique()
            ->values()
            ->all();

        return response()->json([
            // 'products' => $products,
            'colors' => $colors,
        ]);
    }

    public function searchProduct(Request $request){

        $keyword = $request->keyword;
        $products = Product::where('name', 'LIKE', "%{$keyword}%")->orWhere('tags', 'LIKE', "%{$keyword}%")
        ->with('category:id,slug') // ensure 'slug' is present
        ->select('id', 'product_id', 'name', 'slug', 'category_id', 'sub_sku', 'color', 'size', 'tags')
        ->get()
        ->map(function ($item) {
            return [
                'name' => $item->name,
                'tags' => $item->tags,
                'slug' => $item->slug,
                'product_id' => $item->product_id,
                'sub_sku' => $item->sub_sku,
                'color' => $item->color,
                'size' => $item->size,
                'category' => optional($item->category)->slug,
            ];
        })
        ->unique('name')
        ->values() // reset array keys
        ->take(15);
        return response()->json($products);
    }

    public function shopCheckout(){
        // $userId = (Auth::check() && Auth::user()->role != 1) ? Auth::id() : null;
        $user_id = Auth::guard('user')->check() ? Auth::guard('user')->id() : Session::get('guest_session_id');
        $is_guest = WebSetting::where('guest', 0)->first();

        $user = User::find($user_id);

         $total = session('checkout_total');
         $coupon_discount = session('checkout_coupon_discount');
         $subtotalmrp = session('checkout_subtotalmrp');
         $sub_total = session('checkout_sub_total');
         $coupon = session('checkout_coupon');

        if(!$user && $is_guest){
            return redirect()->route('user.login', ['redirect' => 'cart']);
        }
        else{
            return view('shop-checkout', compact('user_id', 'total', 'coupon_discount','subtotalmrp', 'sub_total', 'coupon', 'user'));
        }
        
    }

}
