<?php

namespace App\Http\Controllers\AdminControllers;
use App\Models\AdminModels\Category;
use Illuminate\Validation\Rule;
use App\Models\WebSetting;

use Illuminate\Http\Request;

class SettingController
{
    public function menuOrderList(){
        $category = Category::select('*')->get();
        return view('admin.menu-order-list', ['category'=>$category]);
    }

    public function menuOrderAdd(){
        $categories = Category::select('*')->get();
        return view('admin.menu-order-add', ['categories'=>$categories]);
    }

    public function menuOrderSave(Request $request){

        $validated = $request->validate([
            'order' => 'required|unique:categories',
            'category_id' => 'required',
        ]);
        if($request->category_id){
        $category = Category::findOrFail($request->category_id);
        $category->order = $request->order;
        $category->save();
        }
        return redirect()->route('menu.order.list');

    }

    public function menuOrderEdit($id){
        $categories = Category::select('*')->get();
        $cate = Category::where('id', $id)->first();
        return view('admin.menu-order-edit', ['categories'=>$categories, 'cate'=>$cate]);
    }

    public function menuOrderUpdate(Request $request, $id)
    {
        $validated = $request->validate([
            // 'order' => [
            // 'required',
            // Rule::unique('categories')->ignore($id),
            // ],
            'category_id' => 'required',
        ]);
        if($request->category_id){
        $category = Category::findOrFail($request->category_id);
        $category->order = $request->order;
        $category->save();
        }
        return redirect()->route('menu.order.list');
    }

    public function subCategoryDelete(Request $request, $id)
    {
         $sub_category =  SubCategory::where('id', $id)->first();
         $sub_category->delete();
         $childcategory = ChildCategory::where('sub_category_id', $id)->first();
        if($childcategory){
            $childcategory->delete();
        }
         return redirect()->route('sub.category.list')->with('success', 'Sub category successfully deleted!');
    }

    public function webSetting(){
        $web_setting = WebSetting::first();
        return view('admin.web-setting', compact('web_setting'));
    }

    public function guestUpdate(){

        $web_setting = WebSetting::first();
        
        if($web_setting->guest == 0){
           $web_setting->guest = 1;
        }
        else{
            $web_setting->guest = 0;
        }
        $web_setting->save();

        return back();
    }
}
