<?php

namespace App\Http\Controllers\AdminControllers;

use Illuminate\Http\Request;
use Illuminate\Support\Str;
use App\Models\AdminModels\Attribute;
use App\Models\AdminModels\AttributeValue;

class ProductVariantController
{
    public function attributeAdd(){
        return view('admin.product-variant.attribute-add');
    }

    public function attributeSave(Request $request){

        $validated = $request->validate([
            'name' => 'required|string|max:255',
            'status' => 'required|string|max:50',
        ]);

        $attribute = new Attribute();
        $attribute->name = $request->name;
        $attribute->status = $request->status;
        $attribute->slug = Str::slug($request->name);
        $attribute->save();

        return redirect()->route('attribute.list')->with('success', 'product variant inserted successfully!');
    }

    public function attributeList(){

        $attribute = Attribute::select('*')->get();
        return view('admin.product-variant.attribute-list', ['attribute'=>$attribute]);

    }

    public function attributeEdit($id){
        $attribute = Attribute::where('id', $id)->first();
        return view('admin.product-variant.attribute-edit', ['attribute'=>$attribute]);
    }

    public function attributeUpdate(Request $request, $id)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'status' => 'required|string|max:50',
        ]);

        $attribute = Attribute::findOrFail($id);
        $attribute->name = $request->name;
        $attribute->status = $request->status;
        $attribute->slug = Str::slug($request->name);

        $attribute->save();

        return redirect()->route('attribute.list')->with('success', 'product variant type successfully!');
    }


    public function attributeDelete($id){
        $productVariant = Attribute::where('id', $id)->first();
        $productVariant->delete();
        return redirect()->route('attribute.list')->with('success', 'product variant type successfully deleted');
    }


    public function attributeValueAdd(){

        $attributes = Attribute::orderBy('id', 'DESC')->get();

        return view('admin.product-variant.attribute-value-add', compact('attributes'));
    }

    public function attributeValueSave(Request $request){

        $validated = $request->validate([
            'attribute_id' => 'required|int',
            'value' => 'required',
        ]);

        $attribute = new AttributeValue();
        $attribute->attribute_id = $request->attribute_id;
        $attribute->value = $request->value;
        $attribute->save();

        return redirect()->route('attribute.value.list')->with('success', 'product variant inserted successfully!');
    }

    public function attributeValueList(){

        $attribute = AttributeValue::orderBy('id', 'DESC')->with('attribute')->select('*')->get();
        
        return view('admin.product-variant.attribute-value-list', ['attribute'=>$attribute]);

    }

    public function attributeValueEdit($id){
        $attributes = Attribute::orderBy('id', 'DESC')->get();
        $attributeValue = AttributeValue::where('id', $id)->first();
        return view('admin.product-variant.attribute-value-edit', ['attributeValue'=>$attributeValue, 'attributes'=>$attributes]);
    }

    public function attributeValueUpdate(Request $request, $id)
    {
        $request->validate([
            'attribute_id' => 'required|int',
            'value' => 'required',
        ]);

        $attributeValue = AttributeValue::findOrFail($id);
        $attributeValue->attribute_id = $request->attribute_id;
        $attributeValue->value = $request->value;
        $attributeValue->save();

        return redirect()->route('attribute.value.list')->with('success', 'product variant type successfully!');
    }


    public function attributeValueDelete($id){
        $attributeValue = AttributeValue::where('id', $id)->first();
        $attributeValue->delete();
        return redirect()->route('attribute.value.list')->with('success', 'product variant type successfully deleted');
    }
}
