<?php

namespace App\Http\Controllers\AdminControllers;

use Illuminate\Http\Request;
use App\Models\AdminModels\ChildCategory;
use App\Models\AdminModels\SubCategory;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Str;

class ChildController
{

    public function childCategoryAdd(){
        $sub_categories = SubCategory::select('*')->with('category')->get();
        return view('admin.child-category-add', ['sub_categories' => $sub_categories]);
    }

    public function childCategorySave(Request $request){

        $validated = $request->validate([
            'name' => 'required|string|max:255',
            'sub_category_id' => 'required|integer',
            'status' => 'required|string|max:50',
            'meta_title' => 'required|string|max:255',
            'image' => 'required|image|mimes:jpeg,png,jpg,webp,gif,svg|max:2048',
        ]);

        $category = new ChildCategory();
        $category->name = $request->name;
        $category->sub_category_id = $request->sub_category_id;
        $category->status = $request->status;
        $category->slug = Str::slug($request->name);
        $category->meta_title = $request->meta_title;
        $category->meta_description = $request->meta_description;
        $category->meta_keywords = $request->meta_keywords;

        if ($request->hasFile('image')) {

            $image = $request->file('image');
            $imageName = time() . '_' . $image->getClientOriginalName();
            $image->move(public_path('uploads/child-categories'), $imageName);
            $category->image = $imageName;
        }
        $category->save();

        return redirect()->route('child.category.list')->with('success', 'category inserted successfully!');
    }

    public function childCategoryList(){

        $child_category = ChildCategory::select('*')->get();
        return view('admin.child-category-list', ['child_category'=>$child_category]);

    }

    public function childCategoryEdit($id){
        $sub_categories = SubCategory::select('*')->get();
        $child_category = ChildCategory::where('id', $id)->first();
        return view('admin.child-category-edit', ['child_category'=>$child_category, 'sub_categories'=>$sub_categories]);
    }

    public function childCategoryUpdate(Request $request, $id)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'sub_category_id' => 'required|integer',
            'status' => 'required|string|max:50',
            'meta_title' => 'required|string|max:255',
            'image' => 'image|mimes:jpeg,png,jpg,webp,gif,svg|max:2048',
        ]);

        $category = ChildCategory::findOrFail($id);
        $category->name = $request->name;
        $category->sub_category_id = $request->sub_category_id;
        $category->status = $request->status;
        $category->slug = Str::slug($request->name);
        $category->meta_title = $request->meta_title;
        $category->meta_description = $request->meta_description;
        $category->meta_keywords = $request->meta_keywords;

        if ($request->hasFile('image')) {

            $oldImage = public_path('uploads/child-categories/' . $category->image);
            if (File::exists($oldImage)) {
                File::delete($oldImage);
            }
            $image = $request->file('image');
            $imageName = time() . '_' . $image->getClientOriginalName();
            $image->move(public_path('uploads/child-categories'), $imageName);
            $category->image = $imageName;
        }

        $category->save();

        return redirect()->route('child.category.list')->with('success', 'Category updated successfully!');
    }


    public function childCategoryDelete($id){
        $category = ChildCategory::where('id', $id)->first();
        $category->delete();
        return redirect()->route('child.category.list')->with('success', 'Category successfully deleted');
    }
    

}
