<?php

namespace App\Http\Controllers\AdminControllers;


use Illuminate\Http\Request;
use App\Models\AdminModels\Category;
use App\Models\AdminModels\SubCategory;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Str;

class CategoryController
{

    public function index(){
        $category = Category::select('*')->get();
        return $category;
    }

    public function categoryAdd(){
        return view('admin.category-add');
    }

    public function categorySave(Request $request){

        $validated = $request->validate([
            'name' => 'required|string|max:255',
            'status' => 'required|string|max:50',
            'meta_title' => 'required|string|max:255',
            'image' => 'required|image|mimes:jpeg,png,jpg,webp,gif,svg|max:2048',
        ]);

        $category = new Category();
        $category->name = $request->name;
        $category->status = $request->status;
        $category->slug = Str::slug($request->name);       
        $category->meta_title = $request->meta_title;
        $category->meta_description = $request->meta_description;
        $category->meta_keywords = $request->meta_keywords;


        if ($request->hasFile('image')) {

            $image = $request->file('image');
            $imageName = time() . '_' . $image->getClientOriginalName();
            $image->move(public_path('uploads/categories'), $imageName);
            $category->image = $imageName;
        }

        $category->save();

        return redirect()->route('category.list')->with('success', 'category inserted successfully!');
    }

    public function categoryList(){

        $category = Category::select('*')->get();
        return view('admin.category-list', ['category'=>$category]);

    }

    public function categoryEdit($id){
        $category = Category::where('id', $id)->first();
        return view('admin.category-edit', ['category'=>$category]);
    }

    public function categoryUpdate(Request $request, $id)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'status' => 'required|string|max:50',
            'meta_title' => 'required|string|max:255',
            'image' => 'image|mimes:jpeg,png,jpg,webp,gif,svg|max:2048',
        ]);

        $category = Category::findOrFail($id);
        $category->name = $request->name;
        $category->status = $request->status;
        $category->slug = Str::slug($request->name);
        $category->meta_title = $request->meta_title;
        $category->meta_description = $request->meta_description;
        $category->meta_keywords = $request->meta_keywords;

        if ($request->hasFile('image')) {

            $oldImage = public_path('uploads/categories/' . $category->image);
            if (File::exists($oldImage)) {
                File::delete($oldImage);
            }
            $image = $request->file('image');
            $imageName = time() . '_' . $image->getClientOriginalName();
            $image->move(public_path('uploads/categories'), $imageName);
            $category->image = $imageName;
        }

        $category->save();

        return redirect()->route('category.list')->with('success', 'Category updated successfully!');
    }


    public function categoryDelete($id){
        $category = Category::where('id', $id)->first();
        $category->delete();
        $subcategory = SubCategory::where('category_id', $id)->first();
        if($subcategory){
            $subcategory->delete();
        }
        return redirect()->route('category.list')->with('success', 'Category successfully deleted');
    }
    
}
